<?php
namespace DevOwl\CacheInvalidate\caches;

use TFCache;
use DevOwl\CacheInvalidate\AbstractCache;

/**
 * Themify cache.
 *
 * @see https://themify.me/
 * @codeCoverageIgnore
 */
class ThemifyImpl extends AbstractCache {
    const IDENTIFIER = 'themify';

    // Documented in AbstractCache
    public function isActive() {
        return class_exists(TFCache::class);
    }

    // Documented in AbstractCache
    public function invalidate() {
        return TFCache::remove_cache('blog');
    }

    // Documented in AbstractCache
    public function label() {
        return 'Themify Cache';
    }
}
