import { __, _i } from "../../utils/i18n.js";

import type { FC } from "react";

const A11yNotice: FC<{
    text: string;
    severity: "error" | "warning";
}> = ({ text, severity }) => {
    return (
        <div className={`notice notice-${severity} inline below-h2 notice-alt`} style={{ margin: "10px 0" }}>
            <p>
                {_i(text, {
                    aPerc: (
                        <a href={__("https://www.w3.org/TR/WCAG22/#perceivable")} target="_blank" rel="noreferrer" />
                    ),
                    aEuMinimum: (
                        <a
                            href={__("https://eur-lex.europa.eu/legal-content/EN/TXT/?uri=celex:32019L0882")}
                            target="_blank"
                            rel="noreferrer"
                        />
                    ),
                })}
            </p>
        </div>
    );
};

export { A11yNotice };
