import { useCustomControl } from "../contexts/customControlContextFactory.js";

import type { FC, ReactNode } from "react";

const ControlFieldset: FC<{ children: ReactNode }> = ({ children }) => {
    const {
        params: { label, description, skipFieldSet, className },
        initializeNotifications,
    } = useCustomControl();

    return skipFieldSet ? (
        <div className={className || ""}>{children}</div>
    ) : (
        <>
            {!!label && <span className="customize-control-title">{label}</span>}
            {!!initializeNotifications && (
                <div
                    className="customize-control-notifications-container"
                    style={{ display: "none" }}
                    ref={initializeNotifications}
                ></div>
            )}
            {!!description && (
                <span
                    className="description customize-control-description"
                    dangerouslySetInnerHTML={{ __html: description }}
                ></span>
            )}
            <div className={`customize-control-content ${className || ""}`}>{children}</div>
        </>
    );
};

export { ControlFieldset };
