import { useCustomControl } from "../contexts/customControlContextFactory.js";

import type { FC } from "react";

type CustomHTMLParams = object;

const CustomHTML: FC = () => {
    const {
        params: { description },
    } = useCustomControl();

    return <>{!!description && <span dangerouslySetInnerHTML={{ __html: description }}></span>}</>;
};

export { CustomHTML, type CustomHTMLParams };
