import { useCustomControl } from "../contexts/customControlContextFactory.js";

import type { FC } from "react";
import "../style/controls/headline.scss";

type HeadlineParams = {
    level?: number;
};

const Headline: FC = () => {
    const {
        params: { label, description, level },
    } = useCustomControl();
    const HLevel = `h${level}` as any;

    return (
        <>
            <HLevel>{label}</HLevel>
            {!!description && (
                <span
                    className="description customize-control-description"
                    dangerouslySetInnerHTML={{ __html: description }}
                ></span>
            )}
        </>
    );
};

export { Headline, type HeadlineParams };
