import { useCustomControl } from "../contexts/customControlContextFactory.js";

import type { ChangeEvent, FC } from "react";
import "../style/controls/rangeInput.scss";

type RangeInputValue = number;

type RangeInputParams = {
    unit?: string;
    inputAttrs: {
        min: number;
        max: number;
        step: number;
    };
};

const RangeInput: FC = () => {
    const {
        value,
        setValue,
        params: { unit, inputAttrs },
    } = useCustomControl<RangeInputValue, RangeInputParams>();

    const handleChange = (e: ChangeEvent<HTMLInputElement>) => {
        setValue(+e.target.value);
    };

    const inputCommonAttributes = {
        ...inputAttrs,
        value,
        onChange: handleChange,
    };

    return (
        <>
            <input type="range" {...inputCommonAttributes} />
            <div data-unit={unit || undefined}>
                <input type="number" {...inputCommonAttributes} />
            </div>
        </>
    );
};

export { RangeInput, type RangeInputValue, type RangeInputParams };
