import { getSidebarCustomize } from "../sidebar/getSidebarCustomize.js";

/**
 * Listen to value changes and execute a callback.
 *
 * @param settings
 * @param onChange
 */
function listenChanges<T extends { [section: string]: { [setting: string]: string } }>(
    settings: T,
    onChange: (section: keyof T, setting: string, newValue: any) => void,
) {
    const customize = getSidebarCustomize();
    for (const section of Object.keys(settings)) {
        const sectionSettings = settings[section];

        for (const setting of Object.keys(sectionSettings)) {
            const customizeKey = (sectionSettings as any)[setting] as string;
            customize(customizeKey, (value: any) => {
                value.bind("change", (newValue: any) => {
                    onChange(section, setting, newValue);
                });
            });
        }
    }
}

export { listenChanges };
