import $ from "jquery";
import { createRoot } from "react-dom/client";

import { A11yContrastRatio } from "../../components/a11y/contrastRatio.js";
import { getSidebarCustomize } from "../getSidebarCustomize.js";

import type { ComponentProps } from "react";

/**
 * Add a `A11yContrastRatio` to a given set of settings and output a warning or error message
 * when a minimum ratio got not reached. The "Contrast ratio:" and notice is only rendered
 * to the second (`props.settings[1]`) setting.
 */
function a11yConstrastRatio(props: ComponentProps<typeof A11yContrastRatio>) {
    const customize = getSidebarCustomize();

    customize.control(props.settings[1], ({ container }: any) => {
        const root = createRoot(
            $("<div />")
                .addClass("customize-control-iris-contrast-ratio")
                .appendTo(container.find(".wp-picker-holder"))
                .get(0),
        );
        root.render(<A11yContrastRatio {...props} />);
    });
}

export { a11yConstrastRatio };
