import $ from "jquery";
import { createRoot } from "react-dom/client";

import { A11yFontSize } from "../../components/a11y/fontSize.js";
import { getSidebarCustomize } from "../getSidebarCustomize.js";

import type { ComponentProps } from "react";

/**
 * Add a `A11yFontSize` to a given set of settings and output a warning or error message
 * when a not-accessible font size got selected. The notice is only rendered
 * to the first (`props.settings[0]`) setting.
 */
function a11yFontSize(props: ComponentProps<typeof A11yFontSize>) {
    const customize = getSidebarCustomize();

    customize.control(props.settings[0], ({ container }: any) => {
        const root = createRoot($("<div />").addClass("customize-control-a11y-font-size").appendTo(container).get(0));
        root.render(<A11yFontSize {...props} />);
    });
}

export { a11yFontSize };
