import $ from "jquery";
import { createRoot } from "react-dom/client";

import { A11yFontWeight } from "../../components/a11y/fontWeight.js";
import { getSidebarCustomize } from "../getSidebarCustomize.js";

import type { ComponentProps } from "react";

/**
 * Add a `A11yFontWeight` to a given set of settings and output a warning or error message
 * when a not-accessible font weight got selected. The notice is only rendered
 * to the first (`props.settings[0]`) setting.
 */
function a11yFontWeight(props: ComponentProps<typeof A11yFontWeight>) {
    const customize = getSidebarCustomize();

    customize.control(props.settings[0], ({ container }: any) => {
        const root = createRoot($("<div />").addClass("customize-control-a11y-font-weight").appendTo(container).get(0));
        root.render(<A11yFontWeight {...props} />);
    });
}

export { a11yFontWeight };
