import $ from "jquery";
import { createRoot } from "react-dom/client";

import { A11yTextDecoration } from "../../components/a11y/textDecoration.js";
import { getSidebarCustomize } from "../getSidebarCustomize.js";

import type { ComponentProps } from "react";

/**
 * Add a `A11yTextDecoration` to a given set of settings and output a warning or error message
 * when a not-accessible font weight got selected. The notice is only rendered
 * to the first (`props.settings[0]`) setting.
 */
function a11yTextDecoration(props: ComponentProps<typeof A11yTextDecoration>) {
    const customize = getSidebarCustomize();

    customize.control(props.settings[0], ({ container }: any) => {
        const root = createRoot(
            $("<div />").addClass("customize-control-a11y-text-decoration").appendTo(container).get(0),
        );
        root.render(<A11yTextDecoration {...props} />);
    });
}

export { a11yTextDecoration };
