import { customControlBackboneView } from "./customControlBackboneView.js";
import { getSidebarCustomize } from "./getSidebarCustomize.js";

/**
 * Register a custom control.
 *
 * @param controls
 */
function customControl(controls: { [type: string]: Parameters<typeof customControlBackboneView>[0] }) {
    const customize = getSidebarCustomize();
    for (const type of Object.keys(controls)) {
        const control = controls[type];

        // Register control in available constructors
        if (!customize.controlConstructor[type]) {
            customize.controlConstructor[type] = customControlBackboneView(control);
        }
    }
}

export { customControl };
