import { addContentBesideSection } from "./addContentBesideSection.js";
import { conditionalControls } from "./conditionalControls.js";
import { customControl } from "./customControl.js";
import { getSidebarCustomize } from "./getSidebarCustomize.js";
import { initializeTinyMce } from "./initializeTinyMce.js";
import { makeDefaultsResettable } from "./makeDefaultsResettable.js";
import { ready } from "./ready.js";
import { CssMarginInput } from "../components/cssMarginInput.js";
import { CustomHTML } from "../components/customHtml.js";
import { Headline } from "../components/headline.js";
import { RangeInput } from "../components/rangeInput.js";

import type { CustomizeIds } from "../types/customizeIds.js";
import type { CustomizeValues } from "../types/customizeValues.js";

/**
 * A factory functionality which provides different implementations especially
 * for the "sidebar" use case. Also, it predefine some controls.
 */
function sidebarFactory({
    panel,
    ids,
    defaults,
    onReady,
    conditionals,
    controls,
    contentBesideSection,
}: {
    panel: string;
    ids: CustomizeIds;
    defaults: CustomizeValues;
    onReady?: Parameters<typeof ready>[0];
    conditionals?: Parameters<typeof conditionalControls>[1];
    controls?: Parameters<typeof customControl>[0];
    contentBesideSection?: Parameters<typeof addContentBesideSection>[0];
}) {
    ready((customize) => {
        // Only run the factory if panel exists
        if (!getSidebarCustomize().panel(panel)) {
            return;
        }

        conditionals && conditionalControls(panel, conditionals);
        contentBesideSection && addContentBesideSection(contentBesideSection);
        makeDefaultsResettable(ids, defaults);
        initializeTinyMce();
        onReady(customize);
    });

    controls && customControl(controls);

    // Predefine components
    customControl({
        cssMargin: CssMarginInput,
        rangeInput: RangeInput,
        headline: Headline,
        customHtml: CustomHTML,
    });

    return true;
}

export { sidebarFactory };
