import { getSanitizedControlValue } from "./getSanitizedControlValue.js";

/**
 * Check if a given control has a different value against the default.
 */
function hasControlChanged(controlId: string, defaultValue: any) {
    return JSON.stringify(getSanitizedControlValue(controlId, defaultValue)) !== JSON.stringify(defaultValue);
}

export { hasControlChanged };
