import { getSidebarCustomize } from "./getSidebarCustomize.js";

/**
 * Execute callback when customize is ready (only needed on sidebar assets).
 *
 * @param callback
 */
function ready(callback: (customize: ReturnType<typeof getSidebarCustomize>) => void) {
    const customize = getSidebarCustomize();
    customize.bind("ready", () => {
        callback(customize);
    });
}

export { ready };
