/**
 * Calculate luminosity of a given `#RRGGBB` string.
 *
 * Also ported to `ContrastRatioValidator.php`.
 *
 * @see http://www.w3.org/TR/WCAG20/#relativeluminancedef
 */
function getLuminosity(colorString: string) {
    const color = colorString.substring(1);
    let r = parseInt(color.substr(0, 2), 16) / 255;
    let g = parseInt(color.substr(2, 2), 16) / 255;
    let b = parseInt(color.substr(4, 2), 16) / 255;

    r = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
    g = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
    b = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);

    return 0.2126 * r + 0.7152 * g + 0.0722 * b;
}

export { getLuminosity };
