import { getLuminosity } from "./getLuminosity.js";

/**
 * Calculate contrast ratio of two given `#RRGGBB` strings.
 *
 * Also ported to `ContrastRatioValidator.php`.
 *
 * @param string $color1
 * @param string $color2
 * @see http://www.w3.org/TR/WCAG20/#contrast-ratiodef
 */
function getLuminosityRatio($color1: string, $color2: string) {
    const l1 = getLuminosity($color1);
    const l2 = getLuminosity($color2);

    return l1 > l2 ? (l1 + 0.05) / (l2 + 0.05) : (l2 + 0.05) / (l1 + 0.05);
}

export { getLuminosityRatio };
