import dompurify from "dompurify";

/**
 * Sanitize HTML to prevent XSS attacks.
 *
 * This is useful for controls which use the `postMessage` transport instead of `refresh`
 * and when we want to sanitize the HTML before using it.
 */
function xssHtmlSanitize(html: string) {
    return dompurify.sanitize(html, { USE_PROFILES: { html: true } });
}

export { xssHtmlSanitize };
