const startComment = "onlypro:start";
const endComment = "onlypro:end";
const regexPattern = new RegExp(
    `([\\t ]*)\\/\\* ?${startComment} ?\\*\\/[\\s\\S]*?\\/\\* ?${endComment} ?\\*\\/[\\t ]*\\n?`,
    "g",
);

/**
 * Loader which removes onlypro:start parts from the source file.
 * This must be solved over a custom loader (https://github.com/webpack/webpack/issues/9940)
 */
function StripLiteBlockLoader(content) {
    this.cacheable && this.cacheable(true);
    return content.replace(regexPattern, "$1/* Silence is golden... Until you have PRO Version! */\n");
}

// eslint-disable-next-line import/no-default-export
export default StripLiteBlockLoader;
