import { commonRequest } from "@devowl-wp/utils";

import { locationRestCopyPost } from "../wp-api/copy.post.js";

import type { ParamsRouteCopyPost, RequestRouteCopyPost, ResponseRouteCopyPost } from "../wp-api/copy.post.js";

/**
 * Create a copy of a multilingual object like post or term.
 */
async function createCopy(objectType: string, id: number, targetLocale: string) {
    const { root, nonce } = (window as any).wpApiSettings;
    const { translations } = await commonRequest<RequestRouteCopyPost, ParamsRouteCopyPost, ResponseRouteCopyPost>({
        location: locationRestCopyPost,
        options: {
            restRoot: root as string,
            restNonce: nonce as string,
            restNamespace: "wp/v2",
            restQuery: {},
        },
        request: {
            id,
            targetLocale,
        },
        params: {
            objectType,
        },
    });

    return translations[targetLocale];
}

export { createCopy };
