import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestCopyPost: RouteLocationInterface = {
    path: "/:objectType/multilingual/copy",
    namespace: "wp/v2",
    method: RouteHttpVerb.POST,
};

interface RequestRouteCopyPost extends RouteRequestInterface {
    id: number;
    targetLocale?: string;
}

interface ParamsRouteCopyPost extends RouteParamsInterface {
    objectType: string;
}

interface ResponseRouteCopyPost extends RouteResponseInterface {
    sourceId: number;
    sourceLocale: string;
    targetLocale: string;
    type: string;
    translations: Record<
        string,
        {
            id: number;
            taxonomies?: Record<string, number[]>;
        }
    >;
}

export { locationRestCopyPost, type RequestRouteCopyPost, type ParamsRouteCopyPost, type ResponseRouteCopyPost };
