<?php
namespace Weglot\Client\Api {
    /**
     * Class LanguageEntry.
     */
    class LanguageEntry {
        /**
         * Get english name for this language.
         *
         * @return string
         */
        public function getEnglishName() {
            // Silence is golden.
        }
    }
}

namespace WeglotWP\Services {
    use Weglot\Client\Api\LanguageEntry;

    /**
     * Weglot translation service.
     */
    class Translate_Service_Weglot {
        /**
         * Set the current language.
         *
         * @param LanguageEntry $current_language
         * @return Translate_Service_Weglot
         */
        public function set_current_language($current_language) {
            // Silence is golden.
        }
    }

    /**
     * Language service
     *
     * @since 2.0
     */
    class Language_Service_Weglot {
        /**
         * Get language entry from the internal code
         *
         * @param string $internal_code
         * @return LanguageEntry
         */
        public function get_language_from_internal($internal_code) {
            // Silence is golden.
        }
    }
}

namespace Weglot\Util {
    /**
     * Class Url.
     */
    class Url {
        /**
         * Returns array with all possible URL for current Request
         *
         * @return array
         */
        public function getAllUrls() {
            // Silence is golden.
        }
    }
}

namespace {
    /**
     * `weglot_create_url_object`.
     *
     * @since 2.0.4
     * @param string $url
     * @return Weglot\Util\Url
     */
    function weglot_create_url_object($url) {
        // Silence is golden.
    }

    /**
     * Get current language
     * @return string
     * @throws Exception
     * @since 2.0
     * @see https://developers.weglot.com/wordpress/helpers-functions#weglot_get_current_language
     */
    function weglot_get_current_language() {
        // Silence is golden.
    }

    /**
     * Get original language
     *
     * @return string
     * @throws Exception
     * @since 2.0
     * @see https://developers.weglot.com/wordpress/helpers-functions#weglot_get_original_language
     */
    function weglot_get_original_language() {
        // Silence is golden.
    }

    /**
     * Get destination language with filters
     *
     * @return object[]
     * @throws Exception
     * @since 2.0
     * @see https://developers.weglot.com/wordpress/helpers-functions#weglot_get_destination_languages
     */
    function weglot_get_destination_languages() {
        // Silence is golden.
    }

    /**
     * Get a service Weglot
     *
     * @param string $service
     * @return object
     * @throws Exception
     * @see https://developers.weglot.com/wordpress/helpers-functions#weglot_get_service
     */
    function weglot_get_service($service) {
        // Silence is golden.
    }

    /**
     * This function is used by users to create their own language switcher.
     * It returns an array with all the necessary information for the user to create their own custom language switcher.
     *
     * @return array
     *
     * The array returned has the following indexes: language_name, language_code, short_language_name, flag_link, current_page_url
     */
    function trp_custom_language_switcher() {
        return [];
    }

    /**
     * TranslatePress main instance.
     */
    class TRP_Translate_Press {
        /**
         * Get singleton object.
         *
         * @return mixed Singleton object.
         */
        public static function get_trp_instance() {
            // Silence is golden.
        }
    }

    /**
     * Class TRP_Url_Converter
     *
     * Manages urls of translated pages.
     */
    class TRP_Url_Converter {
        /**
         * Returns language-specific url for given language.
         *
         * Defaults to current Url and current language.
         *
         * @param string $language Language code that we want to translate into.
         * @param string $url Url to encode.
         * @param string $trp_link_is_processed
         * @return string
         */
        public function get_url_for_language(
            $language = null,
            $url = null,
            $trp_link_is_processed = '#TRPLINKPROCESSED'
        ) {
            // Silence is golden.
        }
    }

    /**
     * TranslatePress renderer.
     */
    class TRP_Translation_Render {
        /**
         * Return translations for given strings in given language code.
         *
         * Also stores new strings, calls automatic translations and stores new translations.
         *
         * @param string[] $translateable_strings
         * @param string $language_code
         * @param mixed $block_type
         * @param string[] $skip_machine_translating_strings
         * @return array
         */
        public function process_strings(
            $translateable_strings,
            $language_code,
            $block_type = null,
            $skip_machine_translating_strings = []
        ) {
            // Silence is golden.
        }

        /**
         * Finding translateable strings and replacing with translations.
         *
         * Method called for output buffer.
         *
         * @param string $output        Entire HTML page as string.
         * @return string               Translated HTML page.
         */
        public function translate_page($output) {
            // Silence is golden.
        }
    }

    /**
     * TranslatePress settings.
     */
    class TRP_Settings {
        /**
         * Returns settings_option.
         *
         * @return array Settings option.
         */
        public function get_settings() {
            // Silence is golden.
        }

        /**
         * Returns the value of an individual setting or the default provided.
         *
         * @param string $name
         * @param mixed $default
         * @return mixed Setting Value
         */
        public function get_setting($name, $default = null) {
            // Silence is golden.
        }
    }

    /**
     * TranslatePress translation manager.
     */
    class TRP_Translation_Manager {
        /**
         * Function that strips the gettext tags from a string.
         *
         * @param string $string
         * @return string
         */
        public static function strip_gettext_tags($string) {
            // Silence is golden.
        }
    }

    /**
     * TranslatePress languages.
     */
    class TRP_Languages {
        /**
         * Returns array of full language names for the provided array of language codes.
         *
         * English_or_native_name parameter set to null means to obey the admin settings.
         *
         * @param array $language_codes String array of language codes.
         * @param string $english_or_native_name 'english_name' | 'native_name' | null
         * @return array Associative array with language code as key and full language name as value
         */
        public function get_language_names($language_codes, $english_or_native_name = null) {
            // Silence is golden.
        }

        /**
         * Set proper locale when changing languages with translatepress
         *
         * @param string $locale
         * @return mixed
         */
        public function change_locale($locale) {
            // Silence is golden.
        }
    }

    /**
     * TranslatePress query.
     */
    class TRP_Query {
        /**
         * Return custom table name for given language code.
         *
         * @param string $language_code Language code.
         * @param string $default_language Default language. Defaults to the one from settings.
         * @return string Table name.
         */
        public function get_table_name($language_code, $default_language = null) {
            // Silence is golden.
        }

        /**
         * Update regular (non-gettext) strings in DB
         *
         * @param array $update_strings Array of strings to update
         * @param string $language_code Language code
         * @param array $columns_to_update Array with the name of columns to update id, original, translated, status, block_type, original_id
         */
        public function update_strings(
            $update_strings,
            $language_code,
            $columns_to_update = ['id', 'original', 'translated', 'status', 'block_type', 'original_id']
        ) {
            // Silence is golden.
        }
    }

    /**
     * Returns an array of translations of a term.
     *
     * @api
     * @since 1.8
     *
     * @param int $term_id Term id.
     * @return int[] An associative array of translations with language code as key and translation term id as value.
     */
    function pll_get_term_translations($term_id) {
        // Silence is golden.
    }

    /**
     * Returns an array of translations of a post
     *
     * @since 1.8
     * @param int $post_id
     * @return array an associative array of translations with language code as key and translation post_id as value
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_get_post_translations($post_id) {
        // Silence is golden.
    }

    /**
     * Returns the default language
     *
     * @since 1.0
     * @param string $field Optional, the language field to return ( see PLL_Language ), defaults to 'slug', pass OBJECT constant to get the language object.
     * @return string|\PLL_Language|bool The requested field for the default language
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_default_language($field = 'slug') {
        // Silence is golden.
    }

    /**
     * Returns the current language on frontend
     * Returns the language set in admin language filter on backend ( false if set to all languages )
     *
     * @api
     * @since 0.8.1
     *
     * @param string $field Optional, the language field to return ( see PLL_Language ), defaults to 'slug', pass OBJECT constant to get the language object.
     * @return string|\PLL_Language|bool The requested field for the current language
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_current_language($field = 'slug') {
        // Silence is golden.
    }

    /**
     * Among the post and its translations, returns the id of the post which is in the language represented by $slug
     *
     * @api
     * @since 0.5
     *
     * @param int $post_id post id
     * @param string $slug optional language code, defaults to current language
     * @return int|false|null post id of the translation if exists, false otherwise, null if the current language is not defined yet
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_get_post($post_id, $slug = '') {
        // Silence is golden.
    }

    /**
     * Among the term and its translations, returns the id of the term which is in the language represented by $slug
     *
     * @api
     * @since 0.5
     *
     * @param int $term_id term id
     * @param string $slug optional language code, defaults to current language
     * @return int|false|null term id of the translation if exists, false otherwise, null if the current language is not defined yet
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_get_term($term_id, $slug = '') {
        // Silence is golden.
    }

    /**
     * Registers a string for translation in the "strings translation" panel
     *
     * @api
     * @since 0.6
     *
     * @param string $name a unique name for the string
     * @param string $string the string to register
     * @param string $context optional the group in which the string is registered, defaults to 'polylang'
     * @param bool $multiline optional whether the string table should display a multiline textarea or a single line input, defaults to single line
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_register_string($name, $string, $context = 'polylang', $multiline = false) {
        // Silence is golden.
    }

    /**
     * Translates a string ( previously registered with pll_register_string )
     *
     * @api
     * @since 0.6
     *
     * @param string $string the string to translate
     * @return string the string translation in the current language
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll__($string) {
        // Silence is golden.
    }

    /**
     * Returns the list of available languages
     *
     * List of parameters accepted in $args:
     *
     * hide_empty => hides languages with no posts if set to true ( defaults to false )
     * fields     => return only that field if set ( see PLL_Language for a list of fields )
     *
     * @api
     * @since 1.5
     *
     * @param array $args list of parameters
     * @return array
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_languages_list($args = []) {
        // Silence is golden.
    }

    /**
     * Template tag: displays the language switcher.
     * The function does nothing if used outside the frontend.
     *
     * @api
     * @since 0.5
     *
     * @param array $args {
     *   Optional array of arguments.
     *
     *   @type int    $dropdown               The list is displayed as dropdown if set to 1, defaults to 0.
     *   @type int    $echo                   Echoes the list if set to 1, defaults to 1.
     *   @type int    $hide_if_empty          Hides languages with no posts ( or pages ) if set to 1, defaults to 1.
     *   @type int    $show_flags             Displays flags if set to 1, defaults to 0.
     *   @type int    $show_names             Shows language names if set to 1, defaults to 1.
     *   @type string $display_names_as       Whether to display the language name or its slug, valid options are 'slug' and 'name', defaults to name.
     *   @type int    $force_home             Will always link to the homepage in the translated language if set to 1, defaults to 0.
     *   @type int    $hide_if_no_translation Hides the link if there is no translation if set to 1, defaults to 0.
     *   @type int    $hide_current           Hides the current language if set to 1, defaults to 0.
     *   @type int    $post_id                Returns links to the translations of the post defined by post_id if set, defaults to not set.
     *   @type int    $raw                    Return a raw array instead of html markup if set to 1, defaults to 0.
     *   @type string $item_spacing           Whether to preserve or discard whitespace between list items, valid options are 'preserve' and 'discard', defaults to 'preserve'.
     * }
     * @return string|array Either the html markup of the switcher or the raw elements to build a custom language switcher.
     */
    function pll_the_languages($args = []) {
        return [];
    }

    /**
     * Save posts translations
     *
     * @api
     * @since 1.5
     *
     * @param array $arr an associative array of translations with language code as key and post id as value
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_save_post_translations($arr) {
        // Silence is golden.
    }

    /**
     * Save terms translations
     *
     * @api
     * @since 1.5
     *
     * @param array $arr an associative array of translations with language code as key and term id as value
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_save_term_translations($arr) {
        // Silence is golden.
    }

    /**
     * Set the term language
     *
     * @api
     * @since 1.5
     *
     * @param int $id term id
     * @param string $lang language code
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_set_term_language($id, $lang) {
        // Silence is golden.
    }

    /**
     * Set the post language
     *
     * @api
     * @since 1.5
     *
     * @param int $id post id
     * @param string $lang language code
     * @see https://wordpress.org/plugins/polylang/
     */
    function pll_set_post_language($id, $lang) {
        // Silence is golden.
    }

    /**
     * Get original id of a given id.
     *
     * @param int $element_id
     * @param string $element_type
     * @param boolean $return_original_if_missing
     * @param string $language_code
     * @see https://wpml.org/documentation/support/creating-multilingual-wordpress-themes/language-dependent-ids/
     */
    function icl_object_id(
        $element_id,
        $element_type = null,
        $return_original_if_missing = false,
        $language_code = ''
    ) {
        // Silence is golden.
    }

    /**
     * Register an WPML string in String Translations.
     *
     * @param string $context
     * @param string $name
     * @param string $value
     */
    function icl_register_string($context, $name, $value) {
        // Silence is golden.
    }

    /**
     * WPML configuration management.
     */
    class WPML_Config {
        /**
         * Load config from `wp-config.xml` files without cache.
         */
        static function load_config_run() {
            // Silence is golden.
        }
    }
}
