# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## 1.20.12 (2026-02-02)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.6.3</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* avoid passing complete zod schemas to ContractResponse (CU-869bdvdfh)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.32</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* compatibility with Weblate 5.13 (file form params) and correctly create create/update component source file (CU-869bu5atn)


##### Build System

* correctly fetch languages for frontends (CU-869bu5atn)</details>





## 1.20.11 (2026-01-23)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.15</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* validate container registry image did not catch curl errors correctly (CU-86931jwau)</details>





## 1.20.10 (2026-01-20)


### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


### Maintenance

* upgrade dependencies (CU-86931jwau)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.16</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/api 1.6.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* add HTTP 410 Gone status for deleted reports in order service (CU-8699tgz5g)
* add media upload functionality for logos (CU-8699tgz5g)
* adjust Content-Type handling in fetch client to allow browser to set for FormData (CU-8699tgz5g)
* do not hide internal routes in OpenAPI in non-production environments (CU-8699tgz5g)
* improve developer experience as using schema-mutable methods outside the middleware looses validations and refinements (CU-8699tgz5g)
* prevent duplicate tags in OpenAPI document generation (CU-8699tgz5g)
* review points including 20 (CU-8699tgz5g)
* throw runtime error when refine is used in schema definition (CU-8699tgz5g)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* update refine function parameter naming for consistency across schemas (CU-8699tgz5g)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Documentation

* enhance group management by introducing parent relationships and sorting (CU-8699tgz5g)


##### Maintenance

* upgrade to Node 24 (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.20</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.13</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* only scan current branch with gitleaks (CU-869aw6tca)


##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* use complyforce.com as production domain (CU-8699th190)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.30</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* improve weblate component settings sync for file formats (CU-86931jwau)


##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.21</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* upgrade dependencies (CU-86931jwau)
* upgrade to Node 24 (CU-86931jwau)
* use Relation type for ESM preparation in TypeORM relations (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.22</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.47</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.19</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.20.10</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Code Refactoring

* migrate from Jest to Vitest and clean up related configurations (CU-86931jwau)
* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.52</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Code Refactoring

* migrate to ESM (CU-861mnuuc5)
* remove deprecated packages which are coming with native Node 24 (CU-86931jwau)
* remove fs-extra, use fs:promise and disallow blocking/sync methods (CU-86931jwau)
* replace execSync with spawnSync for improved command execution consistency and security (CU-86931jwau)
* safer usage of imports and exports with TypeScript's verbatimModuleSyntax option (CU-861mhn5rj)
* use package.json#exports everywhere for ESM preparation (CU-861mnuuc5)


##### Maintenance

* make CI build work (CU-861mnuuc5)
* upgrade dependencies (CU-86931jwau)</details>





## 1.20.9 (2026-01-15)


### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)


<details><summary>Development dependency update @devowl-wp/api 1.6.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* refactor new Contract API (CU-8699twn1u)


##### Maintenance

* ai review (CU-8699twn1u)
* fix issues found in testing (CU-8699twn1u)
* fix purpose in contracts ((CU-8699twn1u)
* remove package.json#engines from internal packages (CU-86931jwau)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.20.9</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* remove package.json#engines from internal packages (CU-86931jwau)


##### Performance Improvements

* allow to configure to put the huge JSON to the bottom of the HTML via RCB/Experimental/OptimizedWpLocalizeScript hook (CU-869b9znyx)</details>





## 1.20.8 (2025-12-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.5.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* inital implementation of object-storage package (CU-8697h8axv)
* introduce contract profiles with predefined internal profile to exclude from OpenAPI (CU-8699tgz5g)</details>





## 1.20.7 (2025-12-02)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* implement missing file multipart upload in contracts (CU-869badh12)
* implement missing file multipart upload in contracts fetch-client (CU-869badh12)</details>





## 1.20.6 (2025-11-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.4.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to set a x-tagGroups via route details (CU-8699tgz5g)
* remove redundant delivery ack policy handling (CU-869am6b3b)


##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.12</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* introduce secret-scanner with gitleaks (CU-869aw6tca)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.20</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade zod to latest v4 and refactor to zod imports instead of zod/v4 (CU-8699tgz5g)</details>





## 1.20.5 (2025-10-15)


### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


<details><summary>Development dependency update @devowl-wp/api 1.4.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow to create literal error code responses (CU-8699tgz5g)
* allow to define routes to be a webhook (CU-8699tgz5g)
* enhance vendor management contracts with new API endpoints and schema updates (CU-8699tgz5g)
* make optional recursion schema properties work as expected (CU-8699tgz5g)


##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)


##### Documentation

* user session and magic link routes improved (CU-8699tgz5g)


##### Features

* enhance vendor and user management with new API endpoints and schema updates (CU-8699tgz5g)
* introduce a contract-first design for message brokers with delivery-tuning (CU-869am6b3b)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.28</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* compatibility with the new q parameter in autotranslate since Weblate 5.13 (CU-869ar5pcu)
* update error handling for existing languages (CU-869ar5pcu)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.45</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.20.5</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Continuous Integration

* correctly type check with --project instead of cd into the TypeScript project folder (CU-8697h8axv)</details>





## 1.20.4 (2025-09-24)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.10</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* oss-extract only in master pipeline (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.19</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.19</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.49</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Build System

* introduce .oss.ts and oss-extract CLI (CU-869ad3694)</details>





## 1.20.3 (2025-09-12)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.2</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* allow v1, v2, ... versioning beside semantic versioning for contract (CU-8699tgz5g)
* remove undefined values from URLSearchParams (CU-869ad2n4f)


##### Documentation

* add another example for multiple nested recursion objects (CU-8699tgz5g)
* uncaught Error: Cannot find module 'node:async_hooks'</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.26</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* correctly check when a missing language already existed before (CU-8699tdjp0)</details>





## 1.20.2 (2025-09-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* content length is not always respond by server if using e.g. Cloudflare with Transfer-Encoding: chunked (CU-869ac6g7m)</details>





## 1.20.1 (2025-09-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.3.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* a fetch client need to pass the API version (CU-869a8xjjf)
* run guard schema validations isolated from complete contract schema validation (CU-8699z5dt7)


##### Code Refactoring

* migrate from @devowl-wp/api-request to new fetch client (CU-869a8xjjf)


##### Documentation

* add README for contract-first instroductions (CU-8699z5dt7)


##### Features

* introduce type-safe createFetchClient from all contracts (CU-869a8xjjf)


##### Tests

* add Vitest test runner for our contracts and introduce a first draft for a RPC client type generator (CU-869a8xjjf)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.9</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* introduce Complyforce API backend (CU-8699tdjp0)


##### Continuous Integration

* pnpm-lock.yaml should be considered as common file change (CU-869a875re)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.18</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* switch from node fetch to undici request and make it work with streams and content encoding (CU-86997627z)</details>





# 1.20.0 (2025-08-25)


### Features

* translate into Slovenian and Croatia (CU-8699ce5ba)


<details><summary>Development dependency update @devowl-wp/api 1.2.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make API contracts aware of recursion, parameters to object for refinable schema and switch language contexts correctly (CU-8699z5dt7)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.24</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* after creating a language wait for component to be idle and no task is running (CU-8699ce5ba)


##### Continuous Integration

* handle 404 error correctly after tasks was in progress previously (CU-8699ce5ba)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.20.0</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Features

* translate into Slovenian and Croatia (CU-8699ce5ba)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.47</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Build System

* ignore async_hooks in webpack (CU-8699z5dt7)</details>





## 1.19.54 (2025-08-08)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.2.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Features

* make API contracts compatible with OpenAPI, move guards to API definition and automatically generate API UI (CU-8699z5dt7)</details>





## 1.19.53 (2025-07-29)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* resource group for Docker Review deployments to avoid race condition in Swarm subnet allocation (CU-8699xj5ue)


##### Tests

* introduce optional playwright coverage with c8 (CU-8699761na)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.17</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* compatibility with latest version of Taskfile (CU-8699761na)</details>





## 1.19.52 (2025-07-27)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.35</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* uncaught InvalidArgument IdnaEncoder::encode() Argument [#1](https://git.owlinfra.de/devowlio/devowl-wp/issues/1) () must be of type string|Stringable, NULL given</details>





## 1.19.51 (2025-07-23)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.34</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* better anti ad-block system against Ghostery (CU-8697fw0r4)</details>





## 1.19.50 (2025-07-16)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 1.1.8</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introduce translation options for fields and enhance translation handling in forms (CU-8699f32x9)</details>





## 1.19.49 (2025-07-10)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.32</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* warning is_readable(): open_basedir restriction in effect (CU-8699fqkav)</details>





## 1.19.48 (2025-07-10)


### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)


<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.19</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* allow to recreate the gitlab-ci image manually (CU-8696heugb)
* docker review should not rely on manual containerize job (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.17</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* vitest/prefer-expect-resolves (CU-8698r80f9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.18</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* stabilize scrolling and stats with timer (CU-8696heugb)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.31</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* deprecation notices when using PHP 8.4 in plugin-update-checker dependency (CU-8699fymmg)
* double slash for the chunked translation files (CU-8699fqkav)</details>





## 1.19.47 (2025-06-25)


### Maintenance

* use correct remote language in continuous localization (CU-8699ce5ba)
* use PNPM catalog feature (CU-8699ec2dm)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.9</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.6</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* make contract and entity schemas translatable with i18next (CU-8697uqxnq)


##### Code Refactoring

* introduce contracts for api case study (CU-8697uqxnq)


##### Maintenance

* implement learnings from presentation for API contracts (CU-8697uqxnq)
* started to work on a type-safe client fetch wrapper (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* only release clouflare worker when changes are made (CU-869954ppf)


##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.21</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.16</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)
* use zod/v4 instead of v4 beta package and use Zod locales for error messages (CU-8697uqxnq9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.15</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.40</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Maintenance

* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Bug Fixes

* make the headless content url scanner work in ESM and CJS (CU-8696heugb)


##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.30</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use correct remote language in continuous localization (CU-8699ce5ba)
* use PNPM catalog feature (CU-8699ec2dm)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.44</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Maintenance

* upgrade to TypeScript 5.8 (CU-8697uqxnq)
* use PNPM catalog feature (CU-8699ec2dm)</details>





## 1.19.46 (2025-06-11)


### Maintenance

* replace links with changed slugs (CU-86973be3f)







## 1.19.45 (2025-05-15)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)


##### Continuous Integration

* deploy Cloudflare workers in master and develop environment (CU-8698nqyb0)
* make Cloudflare worker builds available in review apps through own docker image packaged with Wrangler (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.15</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Build System

* add support for Cloudflare workers through wrangler CLI (CU-8698nqyb0)</details>





## 1.19.44 (2025-05-13)


### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.4</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.18</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* move internal apps to our monorepo codebase and introduce swarm (CU-31mn75v)
* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.19</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.14</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* use first mounted container (CU-8694v2pwc)


##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/npm-licenses 0.1.14</summary>


**_Purpose of dependency:_** _Helper functionalities for your project to validate licenses and generate a disclaimer._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.17</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.38</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.28</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.42</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Code Refactoring

* use lint-staged with correct monorepo support (CU-8699154vj)</details>





## 1.19.43 (2025-05-06)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.27</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* fallback for anonymous_localize_script with random fallback key (CU-8697fw0r4)


##### Performance Improvements

* validate JSON before using JSON5 (CU-8698t43qg)</details>





## 1.19.42 (2025-04-25)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.3</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* connect to REVIEW_APP ssh agent (CU-8698fyv1c)
* use GIT_STRATEGY none to fetch the commit in review stop job (CU-8698fyv1c)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.13</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Bug Fixes

* quill editor and WYSIWYG editors are not rendered (CU-8698tv43q)</details>





## 1.19.41 (2025-04-17)


### Maintenance

* update to Weblate 5.11 and use new automattic format (CU-31976hv)


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.17</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* recreate FormData instance on every retry when uploading en file (CU-31976hv)
* weblate 5.11 is not immediatly returning task_url when creating a component (CU-31976hv)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.25</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* update to Weblate 5.11 and use new automattic format (CU-31976hv)</details>





## 1.19.40 (2025-04-08)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* create owlreview.de certificates instead of swarm.owlreview.de (CU-8697hja46)
* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.4</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate to docker swarm for multi-instance capability (CU-8697hja46)</details>





## 1.19.39 (2025-04-02)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.







## 1.19.38 (2025-03-27)


### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.1</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)


##### Continuous Integration

* create wildcard certificate for owlsrv.de (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.15</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* retry up to 10 minutes when component is locked in weblate (CU-8695kguk7)


##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.12</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.10</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.3</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.35</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/ts-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined compiler options for our backends._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.22</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.39</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Code Refactoring

* update ESLint to v9, organize imports, and refactor imports for ESM preparation (CU-8694tbwme)</details>





## 1.19.37 (2025-03-19)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.21</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* invalidate the database scheme when upgrading from free to PRO version (CU-8697zkqjj)</details>





## 1.19.36 (2025-03-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.3</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* show a notice when a template is machine translated (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/api 1.1.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* corrected calculation full machine translation and introduce flag ignoreOnMachineTranslation (CU-8692xtha4)
* enhance machine translation with granular translation options (CU-8692xtha4)
* introduce machine translation status (CU-8692xtha4)


##### Features

* introduce fully machine translated flag to translation status (CU-8692xtha4)
* introduce machine translation including relational metadata service WiP (CU-8692xtha4)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.7.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* build docker containers only after the install job (CU-8697hja46)
* generate production certificates for devowl.io and owlinfra.de (CU-8697hja46)
* generate production Lets Encrypt certificates instead of staging server (CU-8697hja46)


##### Features

* run develop pipeline which creates review app certificates on new branch (CU-8697hja46)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.11</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* implement transaction handling in email and storage operations, update ESLint rules for ORM CUD methods (CU-861mfub3j)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.38</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Build System

* exclude @antv/g2 resources from being inline required as it leads to issues when rendering charts (CU-8695xwj6u)</details>





## 1.19.35 (2025-02-25)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.8</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* create checksum over all certificates (CU-8697hja46)
* generate certificates for swarm revie apps (CU-8697hja46)
* generate regularily certificates with go-acme/lego for our CI runners (CU-8697hja46)
* generate regularily wildcard certificates with go-acme/lego for our CI runners (CU-8697hja46)
* remove orphan certificates (CU-8697hja46)
* use home-runner for WordPress.org push (CU-86980hdd8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.1</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* generate certificates for swarm revie apps (CU-8697hja46)</details>





## 1.19.34 (2025-02-20)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.12</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Maintenance

* console log weblate error message (CU-8695kguk7)</details>





## 1.19.33 (2025-02-17)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.17</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* upgrade to PNPM 10 (CU-8697je0ta)</details>





## 1.19.32 (2025-02-06)


### Maintenance

* typo


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.7</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* always validate docker images when built (CU-8696heugb)


##### Build System

* streamline docker and setup.sh into a Taskfile.setup.yml (CU-8696k3cct)


##### Continuous Integration

* always validate and try to fix docker images (CU-8697pj0tx)
* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Tests

* make static files inclusive domain mapping available in playwright tests and create first test (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.11</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* retry weblate request on socket hang up while uploading a file (CU-8695kguk7)


##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.8.0</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* validate docker images with new CNCF scopes and socket hang up in Weblate translations (CU-8697pj0tx)


##### Features

* new command merge-request-tree (also as VSCode task) to visually show Merge Requests (CU-8692xtha4)</details>





## 1.19.31 (2025-01-14)


### Bug Fixes

* remove potential whitespaces on license keys to improve UX (CU-86974pd8z)


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.10</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* ensure to retry on locked component after 2,5 minutes (CU-8695kguk7)</details>





## 1.19.30 (2024-12-06)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.14</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Build System

* cannot declare class InstalledVersions for composer (CU-8696ru88g)


##### Performance Improvements

* allow profiling PHPUnit tests via webgrind (CU-8696qqa89)</details>





## 1.19.29 (2024-11-07)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 1.0.0</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/api 1.0.0</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* initial release (CU-869656drt)


##### BREAKING CHANGES

* With Real Cookie Banner v5 we enter v1 of dependency packages.</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.13</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Performance Improvements

* too much memory consumed when downloading TCF GVL vendor list and services (CU-8696eq8k1)</details>





## 1.19.28 (2024-10-23)


### Bug Fixes

* do not invalidate license for elb.amazonaws.com (CU-86964ynay)


### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


<details><summary>Development dependency update @devowl-wp/api 0.5.27</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.17</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.6</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)


##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)


##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.9</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* make retry mechanism work with FormData (CU-8695kguk7)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.10</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Tests

* port fast-html-tag and headless-content-blocker to TypeScript with Vitest tests (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.16</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* migrate away from envkey-source to infisical (CU-86959qnq2)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.16</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.12</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* content blocker cannot be saved with empty description text (CU-869625w64)


##### Code Refactoring

* remove jest and phpunit from packages which do not use it (CU-8695mtnyu)</details>





## 1.19.27 (2024-09-26)


### Bug Fixes

* do not invalidate license for azurewebsites.net (CU-8695h2x87)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* provide APP_NAME and APP_VERSION in backend environment (CU-8695emete)
* restore production database dump app-versionized (CU-8695emete)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.8</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* retry 5 times when component is locked (CU-8695kguk7)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.5</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* make public changelog generation work again with latest Taskfile version (CU-8695kgrpr)


##### Maintenance

* update retypeapp (CU-8695kgrpr)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.11</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* remove referer workaround for Strato servers (CU-86954236z)</details>





## 1.19.26 (2024-08-28)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.7</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* performance tuning and shouldUpdate tweaks (CU-861n9jg7k)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.25</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* apply new eslint rules (CU-861n9jg7k)
* introduce translation flag statistics and entity display (CU-861n9jg7k)
* introduce translation flags for translatable strings (CU-8693travj)


##### Code Refactoring

* reordering vars (CU-861n9jg7k)</details>





## 1.19.25 (2024-08-08)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.9</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* some components are not rendered in WordPress < 6.2 (CU-86959qqq1)
* use ReactJSXRuntime for better WordPress 6.6 compatibility (CU-86959qqq1)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.33</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Bug Fixes

* some components are not rendered in WordPress < 6.2 (CU-86959qqq1)
* use ReactJSXRuntime for better WordPress 6.6 compatibility (CU-86959qqq1)</details>





## 1.19.24 (2024-08-01)


### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)


### Maintenance

* **deps :** update dependency php-stubs/wordpress-stubs to v6.6.0


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.6</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.8</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Build System

* generate cachebuster files in a real temporary file to avoid race conditions


##### Code Refactoring

* upgrade to React v18 (createRoot, unmountComponentAtNode, CU-awv3bv)


##### Maintenance

* **deps :** update dependency php-stubs/wordpress-stubs to v6.6.0</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.32</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Code Refactoring

* move react-aiot to @devowl-wp/react-folder-tree within monorepo (CU-awv3bv)</details>





## 1.19.23 (2024-07-17)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.7</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* no longer send referer via URL parameter as this lead to issues with Strato servers (dashboard no longer loads, CU-86954236z)</details>





## 1.19.22 (2024-07-16)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.24</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Maintenance

* suppress logs from requests from nullers (CU-8694xa392)</details>





## 1.19.21 (2024-06-20)


### Bug Fixes

* do not deactivate the license when the hostname differs in letter case (CU-8694uw4y2)


### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* **deps :** update dependency mpratt/embera to v2.0.40
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.4</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/api 0.5.23</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.16</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.7</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.8</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.4</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* remove npm-update-checker CLI command as we use Renovate now (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.14</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm all dependencies (non-major)
* update commander and adm-zip (CU-8694qg0t9)
* update some major dependencies (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.15</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.29</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Maintenance

* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.5</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* remove notice about too many requests to devowl.io servers (CU-8694uj43d)


##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Continuous Integration

* introduce Renovate bot for dependency update automation (CU-8694qg0t9)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update composer dependencies (non-major)
* **deps :** update dependency mpratt/embera to v2.0.40
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* **deps :** update npm all dependencies inclusive some major updates (CU-8694qg0t9)
* update renovate.json (CU-8694qg0t9)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.31</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Build System

* remove babel-loader and babel toolchain and introduce SWC (CU-8694pt2j7)


##### Maintenance

* **deps :** pin dependencies
* **deps :** pin dependencies
* **deps :** update npm (non-major)
* **deps :** update npm (non-major)
* **deps :** update npm all dependencies (non-major)
* upgrade prettier v3 together with eslint flat config and run on all files (fix, format, CU-8694qg0t9)</details>





## 1.19.20 (2024-05-29)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.







## 1.19.19 (2024-05-10)


### Bug Fixes

* delete checkboxes for privacy policy and only print an information for this (CU-861mrzwar)


<details><summary>Development dependency update @devowl-wp/utils 1.19.3</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* do not show admin notice about REST API issues in update admin screen (CU-8694hc398)
* too many requests to license.devowl.io announcements endpoint (CU-86939q6ce)</details>





## 1.19.18 (2024-04-25)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.21</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Bug Fixes

* introducing password login in rcb (CU-86936my3v)


##### Refactoring

* introduce user base interfaces (CU-86936my3v)</details>





## 1.19.17 (2024-04-10)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.19.1</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* update stubs (CU-86949561p)</details>





## 1.19.16 (2024-04-09)


### Bug Fixes

* deactivate license domain detection when running WordPress through WP CLI (CU-869482eaf)


### Build Process

* remove minimal translations el fi and fix localization system (CU-861myr2cq)


<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.13</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Bug Fixes

* scanner finds Google Maps for MyListing theme when Mapbox instead of Google Maps is used (CU-86947zz6j)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.19.0</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* compatibility with Perfmatters DelayJS functionality and Code on page load scripts (CU-869465a82)
* implement a mechanism detecting a defect Consent REST API and recommend knowledgebase articles (CU-8693zknc0)
* use vigenere cipher for obfuscating the REST API URL (CU-8693zknc0)


##### Build Process

* remove minimal translations el fi and fix localization system (CU-861myr2cq)


##### Features

* translations into Hungarian, Romanian, Greek, Finnish and Slovak (CU-863gr8e97)</details>





## 1.19.15 (2024-03-22)


### Bug Fixes

* avoid race conditions when contacting our backend servers to avoid triggering rate limit notice (CU-86939q6ce)


<details><summary>Development dependency update @devowl-wp/utils 1.18.3</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* avoid race conditions when contacting our backend servers to avoid triggering rate limit notice (CU-86939q6ce)</details>





## 1.19.14 (2024-03-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.29</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Bug Fixes

* do not index admin UI in search engines (CU-8693yzxhv)</details>





## 1.19.13 (2024-02-26)


### Bug Fixes

* client property value is empty error message when using serialized siteurl option (CU-8693uhwd7)


### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)


<details><summary>Dependency updates @devowl-wp/react-utils 0.1.2</summary>


**_Purpose of dependency:_** _Provide various React utils, side effect free and tree shakeable._
##### Bug Fixes

* cookie banner cannot be accepted on old Safari browsers (CU-8693u1wzm)


##### Performance

* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)
* improve performance of applying consent and unblocking consent for better INP in Google PageSpeed (CU-8693n1cc5)
* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)
* lazy load data for the second layer / view of the cookie banner (CU-8693n1cc5)
* render shortcodes async and add lazy-require() webpack plugin (CU-8693cqz75)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Performance

* improve performance by not removing cookie banner from DOM after accepting for better INP in Google PageSpeed (CU-8693n1cc5)


##### Refactoring

* move all consent relevant structures and procedures to @devowl-wp/cookie-consent-management (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.7</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Performance

* improve Total Blocking Time in Page Speed Insights by yielding the main thread for TCF cookie banner (CU-8693n1cc5)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.18.1</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Continuous Integration

* readme-to-json parser did no longer work due to missing taxonomy_exists function (CU-8693wju7t)


##### Performance

* allow to parse big objects localized via wp_localize_script lazily (CU-8693n1cc5)
* do no longer use webpackMode eager in favor of inline-require (CU-8693n1cc5)
* use code splitting for the cookie banner and content blocker to reduce initial download time (CU-8693ubj9a)


##### Refactoring

* move all util functions to @devowl-wp/react-utils (CU-8693cqz75)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.28</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Performance

* improve Total Blocking Time in Page Speed Insights by inlining require statements (CU-8693n1cc5)</details>





## 1.19.12 (2024-02-05)


### Maintenance

* use non-docker URL with HTTPS in development environment to not bypass Traefik (CU-86939q6ce)


### Performance

* save one SQL SELECT query in WordPress admin dashboard (CU-86939q6ce)


### Refactoring

* move some util methods to @devowl-wp/utils (CU-86939q6ce)


<details><summary>Development dependency update @devowl-wp/utils 1.18.0</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Features

* introduce a new notice when a rate limited request was done to devowl.io backend services (CU-86939q6ce)


##### Maintenance

* use non-docker URL with HTTPS in development environment to not bypass Traefik (CU-86939q6ce)


##### Performance

* save one SQL SELECT query in WordPress admin dashboard (CU-86939q6ce)


##### Refactoring

* move some util methods to @devowl-wp/utils (CU-86939q6ce)</details>





## 1.19.11 (2024-01-25)


### Bug Fixes

* allow to copy client UUID by hovering the installation type icon (CU-8693hv7vb)
* show a notice for successor templates which replace other templates (CU-869372jf7)


### Maintenance

* update to antd@5 (CU-863gku332)


<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.6</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.11</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* use project ID to read associated merge request for pipeline (CU-apv5uu)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.17.9</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* php error automatic conversion of false to array is deprecated (CU-apv5uu)
* show a notice for successor templates which replace other templates (CU-869372jf7)
* sometimes the WordPress REST API is contacted infinite when WP heartbeat is deactivated and login no longer valid (CU-8693jq17r)


##### Maintenance

* update to antd@5 (CU-863gku332)


##### Performance

* reduce bundle size by replacing sha-1 by a simple hash function (CU-apv5uu)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.27</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Maintenance

* update to antd@5 (CU-863gku332)</details>





## 1.19.10 (2024-01-18)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.6.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* output ci summary for review application URLs for traefik v2 (CU-2rjtd0)


##### Continuous Integration

* automatically retry to fetch the git repository three times when there is a temporary error (CU-8693j5ngt)
* deploy backends in production to docker-host-6.owlsrv.de (CU-2rjtd0)


##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.2.0</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Features

* introduce public-changelogs command (CU-2mjxz4x)</details>





## 1.19.9 (2024-01-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.17.7</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Build Process

* correctly autoload composer package files autoload.files per plugin (CU-8693dhuhv)</details>





## 1.19.8 (2023-12-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/utils 1.17.6</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* fatal error after latest update as WordPress stubs were no longer compatible with WordPress < 6.2 (CU-8693cg7cp)</details>





## 1.19.7 (2023-12-21)


### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)


<details><summary>Development dependency update @devowl-wp/composer-licenses 0.1.15</summary>


**_Purpose of dependency:_** _Helper functionalities for your composer project to validate licenses and generate a disclaimer._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.1</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Bug Fixes

* correctly check for the SHA of the latest master branch (CU-8693bzjkb)


##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.5</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/phpcs-config 0.1.14</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPCS._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/phpunit-config 0.1.12</summary>


**_Purpose of dependency:_** _Predefined functionalities for PHPUnit._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.17.5</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Maintenance

* upgrade to PHP 8.2 including composer packages (CU-arua06)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.25</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Bug Fixes

* use correct name for long term caching for extracted CSS files (CU-8693bc0d2)</details>





## 1.19.6 (2023-12-19)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.5.0</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* rotate transaction_ids_by_target_id every 14 days (CU-86937dv6w)
* upload did not work with newer Debian version, disable StrictHostKeyChecking for lftp upload (CU-86937dw3d)


##### Features

* allow to skip publish of packages by regular expression in merge request description with target branch master (CU-8693bzjkb)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.1</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* copy files always once and overwrite existing files (CU-8693bq3nh)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.13</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Bug Fixes

* show skipped publish packages as those in the generated CHANGELOG.md files (CU-8693bzjkb)</details>





## 1.19.5 (2023-12-15)


### Refactoring

* use a class instead of an object for continuous localization settings (CU-86938ba8a)


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.8.0</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* allow to configure branch settings via root package.json instead of hardcoded (CU-86938ba8a)
* respect branch settings in weblate-prune-deleted-branches CLI command (CU-86938ba8a)
* show a hint when a language is in Weblate but not configured in package.json in weblate-status command (CU-86938ba8a)


##### Build Process

* do not expose de@formal and nl@formal to Weblate (CU-86938ba8a)


##### Features

* allow to exclude locales from projects with overrides.excludeLocales in package.json settings (CU-86938ba8a)


##### Refactoring

* use a class instead of an object for continuous localization settings (CU-86938ba8a)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.17.3</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* allow to configure capabilities via Activator#registerCapabilities (CU-86938n5gk)
* compatibility with Cloudflare Rocket Loader (CU-86938z54n)


##### Refactoring

* use a class instead of an object for continuous localization settings (CU-86938ba8a)</details>





## 1.19.4 (2023-11-28)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.5</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)


##### Testing

* introduce @devowl-wp/playwright-utils with smoke test functionality (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.4</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.9</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* update Gitlab YAML typings (CU-8692yek74)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.17.2</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Refactoring

* remove all cypress dependencies and tests (CU-8692yek74)</details>





## 1.19.3 (2023-11-24)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.4</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)
* validate production docker compose config on compose YAML changes (CU-86934wg6z)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.7.9</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* do find propagated string translations from other components when merging a branch to another (CU-86932nwn8)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.8</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Bug Fixes

* also delete skipped pipelines and pipelines of deleted branches</details>





## 1.19.2 (2023-11-22)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.7.8</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* machine translate all unfinished strings as changed strings are not detected with nottranslated (CU-86932nwn8)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.17.0</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Features

* introduce batch requests (CU-86930ub71)
* introduce TCF 2.2 / GVL v3 compatibility (CU-863gt04va)</details>





## 1.19.1 (2023-11-16)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.7.7</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Bug Fixes

* always use auto_source=others in Weblate autotranslate to avoid picking inconsistent strings across projects (CU-86932nwn8)
* do not fuzzy autotranslate machine translated strings (CU-86932nwn8)
* use auto translate others instead of download and upload ZIP when creating feature branch in Weblate (CU-86932nwn8)


##### Reverts

* back to ZIP download/upload as it is faster than autotranslate with others (CU-86932nwn8)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.16.1</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* compatibility with WP Meteor optimization plugin (CU-86933j1zb)</details>





# 1.19.0 (2023-11-07)


### Bug Fixes

* remote language codes for cs, da and sv (CU-2gfb42y)


### Build Process

* set @automattic/interpolate-components as enforced check in weblate (CU-2gfb4w6)
* set php-format as enforced check in weblate (CU-2gfb4w6)


### Continuous Integration

* enable machine translation for various languages (CU-2gfb42y)
* translation completeness thresholds defined for main languages (CU-861n4aer5)


### Features

* translations in Spanish, French, Italian, Dutch, Polish, Danish, Swedish, Norwegian, Czech, Portuguese and Romanian (CU-2gfb42y)
* translations in Spanish, French, Italian, Dutch, Polish, Danish, Swedish, Norwegian, Czech, Portuguese and Romanian (CU-2gfb42y)


### Maintenance

* add legal-text to some texts (CU-2gfb42y)


<details><summary>Development dependency update @devowl-wp/continuous-localization 0.7.6</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Continuous Integration

* show inconsistent translations always in translation status (CU-86932cagc)


##### Maintenance

* machine translated strings should be trusted and not set as fuzzy in Weblate (CU-2gfb42y)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.16.0</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* remote language codes for cs, da and sv (CU-2gfb42y)


##### Build Process

* remove local language files from built ZIP file and use remote files (CU-861n4ahzb)
* set @automattic/interpolate-components as enforced check in weblate (CU-2gfb4w6)
* set php-format as enforced check in weblate (CU-2gfb4w6)


##### Continuous Integration

* enable machine translation for various languages (CU-2gfb42y)
* translation completeness thresholds defined for main languages (CU-861n4aer5)


##### Features

* translations in Spanish, French, Italian, Dutch, Polish, Danish, Swedish, Norwegian, Czech, Portuguese and Romanian (CU-2gfb42y)
* translations in Spanish, French, Italian, Dutch, Polish, Danish, Swedish, Norwegian, Czech, Portuguese and Romanian (CU-2gfb42y)</details>





## 1.18.3 (2023-11-02)


### Bug Fixes

* passing null to parameter [#1](https://git.devowl.io/devowlio/devowl-wp/issues/1) () of type string is deprecated







## 1.18.2 (2023-10-27)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.


<details><summary>Development dependency update @devowl-wp/api 0.5.13</summary>


**_Purpose of dependency:_** _Shared typings for all Node.js backends and frontends._
##### Documentation

* update JSDoc, make some methods private and extend some typings (CU-866avtm7z)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.7</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Continuous Integration

* purge master pipelines after 90 days instead of 360</details>





## 1.18.1 (2023-10-12)


### Maintenance

* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* major update webpack components (CU-3cj43t)
* prepare upgrade wizard for v4 release (CU-861n7amqx)


<details><summary>Development dependency update @devowl-wp/continuous-integration 0.4.2</summary>


**_Purpose of dependency:_** _DevOps macros, job templates and jobs for Gitlab CI and @devowl-wp/node-gitlab-ci._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/continuous-localization 0.7.4</summary>


**_Purpose of dependency:_** _Provide a CLI to push and pull localization files from different translation management systems._
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/eslint-config 0.2.3</summary>


**_Purpose of dependency:_** _Provide eslint configuration for our complete monorepo._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/monorepo-utils 0.1.9</summary>


**_Purpose of dependency:_** _Predefined monorepo utilities and tasks._
##### Continuous Integration

* include changelogs from dependencies (CU-2k54tcb)


##### Maintenance

* major update commander (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/node-gitlab-ci 0.7.6</summary>


**_Purpose of dependency:_** _Create dynamic GitLab CI pipelines in JavaScript or TypeScript for each project. Reuse and inherit instructions and avoid duplicate code!_
##### Maintenance

* major update commander (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/regexp-translation-extractor 0.2.19</summary>


**_Purpose of dependency:_** _Provide a performant translation extractor based on regular expression._
##### Maintenance

* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)</details>

<details><summary>Development dependency update @devowl-wp/utils 1.15.13</summary>


**_Purpose of dependency:_** _Utility functionality for all your WordPress plugins._
##### Bug Fixes

* compatibility with latest Swift Performance version (CU-866aybgxm)


##### Maintenance

* drop concurrently package as no longer needed (CU-3cj43t)
* major update apidoc (CU-3cj43t)
* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update tsc-watch immer lint-staged sort-package-json (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* major update webpack components (CU-3cj43t)
* remove supports-color, update focusable-selectors react-quill react-codemirror2 js-cookie (CU-3cj43t)
* update Lerna v7 (CU-31956up)</details>

<details><summary>Development dependency update @devowl-wp/webpack-config 0.2.20</summary>


**_Purpose of dependency:_** _Webpack config builder for multiple ecosystems like standalone React frontends, Antd, Preact and WordPress._
##### Maintenance

* major update jest-junit glob @types/jest jest ts-jest (CU-3cj43t)
* major update tsc-watch immer lint-staged sort-package-json (CU-3cj43t)
* major update typescript [@typescript-eslint](https://git.devowl.io/typescript-eslint) typedoc (CU-3cj43t)
* major update webpack components (CU-3cj43t)</details>





# 1.18.0 (2023-09-29)


### chore

* review 1 (CU-85ztzbdjt)


### docs

* remove not understandable commit messages from changelog (CU-861n7an31)


### feat

* allow to add custom checkboxes to the license activation form (CU-85ztzbdjt)
* make links to legal documents more dynamic (CU-cawgkp)


### fix

* non-network-activated plugin could lead to fatal errors as no License instance is found (CU-866axn3p9)





## 1.17.11 (2023-09-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.10 (2023-09-07)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.9 (2023-09-06)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.8 (2023-08-28)


### build

* use @babel/plugin-proposal-class-properties with updated caniuse-lite database (CU-863h37kvr)





## 1.17.7 (2023-08-24)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.6 (2023-08-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.5 (2023-08-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.4 (2023-08-04)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.3 (2023-08-02)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.17.2 (2023-08-02)


### fix

* implement a mechanism to download language packs from wordpress.org servers (CU-861n4ahzb)





## 1.17.1 (2023-07-18)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





# 1.17.0 (2023-07-06)


### docs

* update filter documentation with more examples and use cases


### feat

* translation into Finnish (CU-863gxj4m4)
* ukrainian translation (CU-863guchwj)


### refactor

* introduce custom ESLint rules ability in @devowl-wp/eslint-config (CU-863gxjbn4)





## 1.16.4 (2023-06-05)


### ci

* technical renaming of German, French, Spanish, Italian and Dutch translations that they contains the formality (CU-2gfb42y)


### fix

* do not detected Bluehost temp.domains as new host (CU-861mvzpqq)
* mapping of language files for copying to correct language (CU-2gfb42y)





## 1.16.3 (2023-05-30)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.16.2 (2023-05-22)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.16.1 (2023-05-21)


### chore

* remove dotenv package (CU-861m6e3mz)





# 1.16.0 (2023-05-19)


### feat

* slovak translation (CU-861mrudp4)





## 1.15.2 (2023-05-12)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.15.1 (2023-05-11)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





# 1.15.0 (2023-04-28)


### feat

* added Norwegian Bokmal translation (nb_NO, CU-863ggghbf)


### fix

* do not show license activation form for users with low capabilities (CU-863gjud71)
* getCurrentBlogLicense did not work as expected within multisite based on subfolders (CU-863gjud71)
* typo in text (CU-863ggghbf)





## 1.14.12 (2023-04-24)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.14.11 (2023-04-19)


### chore

* remove non-ASCII characters from POT files (CU-863gffr77)
* update texts (CU-861mgayvy)


### perf

* wp_load_alloptions called for each subsite within multisite (CU-861med012)


### refactor

* introduce taskfile.dev Taskfiles (CU-85zrrymj0)





## 1.14.10 (2023-03-24)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.14.9 (2023-03-21)


### chore

* introduce new service cloud to better manage service and blocker templates (WIP, CU-2mjzexr)
* update dependencies including TypeScript 4.9, antd and eslint (CU-85zrqk9pd)


### refactor

* rename grunt-continuous-localization to continuous-localization and remove grunt dependency (pure bin, CU-85zrrytg6)





## 1.14.8 (2023-03-14)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.14.7 (2023-03-01)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.14.6 (2023-02-28)


### chore

* update wordpress stubs (CU-863g4efkw)


### fix

* invalid JSON int database helper class with the help of JSON5 (CU-863g4efkw)





## 1.14.5 (2023-02-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.14.4 (2023-02-15)


### fix

* when Google Site Kit plugin is activate warnings are logged (CU-863g1392d)





## 1.14.3 (2023-01-25)


### fix

* check if plugin file exists before getting the plugin name via get_plugin_data (CU-861m900gg)





## 1.14.2 (2023-01-10)


### fix

* better explain the error about license activation limit





## 1.14.1 (2022-12-22)


### chore

* better explain installation type on purpose and link to kb article (CU-388ch1x)
* update all package.json to resolve release conflicts (CU-382p4kb)


### fix

* link on example telemetry should not check/uncheck telemetry checkbox (CU-382p4kb)


### perf

* remove path_join calls and use trailingslashit instead (CU-861m3qqb7)





# 1.14.0 (2022-12-12)


### feat

* allow to deactivate license in deactiation feedback modal dialog (CU-aux3m0)





## 1.13.18 (2022-12-02)


### fix

* do not send empty telemetry data (CU-37hc4hh)
* do not send telemetry data after deactivation of license (CU-37hc4hh)
* log invalid map data in telemetry job and map empty strings to correct bool zero string (CU-37hc4hh)





## 1.13.17 (2022-12-01)


### chore

* adjust telemetry data collection (CU-2ufnyc2)
* execute deferred telemetry data transmit (CU-2ufnyc2)


### fix

* decouple license activation from plugin update mechanism (CU-2ufrate)
* do not automatically deactivate license for compute.amazonaws.com (CU-30ch2z7)





## 1.13.16 (2022-11-18)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.15 (2022-11-15)


### fix

* add a button to enter PRO license and redirct to kb-article in free version (CU-30db841)
* force to use option home_url and siteurl instead of constants when within subdomain MU (CU-33khexz)





## 1.13.14 (2022-11-09)


### refactor

* static trait access (setupConstants, CU-1y7vqm6)





## 1.13.13 (2022-10-31)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.12 (2022-10-25)


### fix

* license activation error 'Client property value is empty' (CU-31zz2mk)





## 1.13.11 (2022-10-11)


### build

* add webpack as dependency to make it compatible with PNPM (CU-3rmk7b)


### chore

* introduce consistent type checking for all TypeScript files (CU-2eap113)
* prepare script management for self-hosted Gitlab migrations (CU-2yt2948)
* rebase conflicts (CU-2eap113)
* start introducing common webpack config for frontends (CU-2eap113)


### fix

* do not automatically deactivate license for compute-amazonaws.com (CU-30ch2z7)
* do not show hint about missing license activation when license is active (CU-2znup7h)





## 1.13.10 (2022-09-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.9 (2022-09-21)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.8 (2022-09-20)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.7 (2022-09-16)


### fix

* do not validate new host when request gets redirected (CU-2z4dheb)





## 1.13.6 (2022-09-06)

**Note:** This package (@devowl-wp/real-product-manager-wp-client) has been updated because a dependency, which is also shipped with this package, has changed.





## 1.13.5 (2022-08-29)


### chore

* introduce devowl-scripts binary (CU-2n41u7h)
* introduce for non-flat node_modules development experience (CU-2n41u7h)
* introduce new command @devowl-wp/grunt-workspaces/update-local-versions (CU-2n41u7h)
* prepare packages for PNPM isolated module mode (CU-2n41u7h)
* rebase conflicts (CU-2n41u7h)


### perf

* drop IE support completely (CU-f72yna)
* permit process.env destructuring to save kb in bundle size (CU-f72yna)





## 1.13.4 (2022-07-06)


### fix

* better error handling when REST API is not available in license modal (CU-2kgpv68)
* php error in Announcement.php when announcements are deactivated (CU-2md9j0g)





## 1.13.3 (2022-06-13)


### fix

* sanitize input fields where needed (CU-2kat97y)





## 1.13.2 (2022-06-08)


### fix

* compatibility with licensing when WPTimeCapsule is active (CU-2jm2ha5)
* do not create license instances too early (CU-2gfcmjv)
* some PHP notices about missing variables (CU-2j8gba7)


### refactor

* use is_multisite instead of function_exists checks (CU-2k54b8m)


### style

* form checkboxes were overriden by global style (CU-2jm244h)





## 1.13.1 (2022-05-13)


### fix

* free version could not be activated with a free license (CU-2evtdgf)





# 1.13.0 (2022-05-09)


### feat

* allow no-usage licensing within multisite with multiple licenses (CU-22bghnd)


### fix

* remove path from thematic connected host names and always use the host name (CU-2dkvrnw)





## 1.12.4 (2022-04-29)


### fix

* patch hostname correctly when syncing with remote within multisite (CU-2chc0vt)
* respect connected thematic hosts also for invalidating the license for new found host (CU-2de0bqb)
* support multisites with more than 100 subsites (CU-2de4am1)





## 1.12.3 (2022-04-20)


### ci

* make build wp package jobs more generic without wp (CU-22h231w)


### fix

* do not invalidate the license for EC2 IP domains (CU-2cbneq2)
* ignore other EC2 and compute units for license deactivation (CU-2cbneq2)


### refactor

* extract composer dev dependencies to their corresponding dev package (CU-22h231w)
* put composer license packages to @devowl-wp/composer-licenses (CU-22h231w)
* rename wordpress-packages and wordpress-plugins folder (CU-22h231w)
* use phpunit-config and phpcs-config in all PHP packages (CU-22h231w)





## 1.12.2 (2022-04-04)


### chore

* simplified consents for license activation (CU-1zg282b)
* translation hungary (CU-21999nd)





## 1.12.1 (2022-03-15)


### chore

* use wildcarded composer repository path (CU-1zvg32c)


### fix

* use correct link for Learn more in license dialog for CodeCanyon products (CU-1jkmq84)


### refactor

* make plugin updates independent of single store (CU-1jkmq84)





# 1.12.0 (2022-01-25)


### feat

* allow to programmatically activate license through WordPress hook (CU-kbaqat)





# 1.11.0 (2022-01-17)


### build

* create cachebuster files only when needed, not in dev env (CU-1z46xp8)
* improve build and CI performance by 50% by using @devowl-wp/regexp-translation-extractor (CU-1z46xp8)


### chore

* sync client properties WP version with each update check (CU-1znbady)


### feat

* allow to get received data from license server for activation (CU-1znbady)


### test

* compatibility with Xdebug 3 (CU-1z46xp8)





# 1.10.0 (2021-12-01)


### feat

* introduce formal german translations (CU-1n9qnvz)





## 1.9.1 (2021-11-11)


### chore

* remove not-finished translations from feature branches to avoid huge ZIP size (CU-1rgn5h3)





# 1.9.0 (2021-10-12)


### feat

* send product version and name to deactivation feedback (CU-12b0yg1)





# 1.8.0 (2021-09-30)


### build

* allow to define allowed locales to make release management possible (CU-1257b2b)
* copy files for i18n so we can drop override hooks and get performance boost (CU-wtt3hy)


### chore

* english translation revision (CU-vhmn9k)
* introduce new developer filter DevOwl/RealProductManager/HostMap/ConnectThematic (CU-1jkutcv)
* prepare for continuous localization with weblate (CU-f94bdr)
* refactor texts to use ellipses instead of ... (CU-f94bdr)
* remove language files from repository (CU-f94bdr)
* review english texts (CU-12w4012)


### ci

* introduce continuous localization (CU-f94bdr)


### feat

* translation into Russian (CU-10hyfnv)


### fix

* enqueue license dialog also in network plugins list (CU-1jz73cx)


### perf

* remove translation overrides in preference of language files (CU-wtt3hy)


### refactor

* grunt-mojito to abstract grunt-continuous-localization package (CU-f94bdr)
* introduce @devowl-wp/continuous-integration





## 1.7.8 (2021-08-31)


### fix

* only validate new hosts when in admin area (CU-yjzbgt)





## 1.7.7 (2021-08-20)


### chore

* update PHP dependencies
* updated PuC





## 1.7.6 (2021-08-10)


### chore

* translations into German (CU-pb8dpn)


### refactor

* split i18n and request methods to save bundle size





## 1.7.5 (2021-07-09)


### fix

* consider port 80 and 443 not as new host for license invalidation
* do not invalidate license in some rare cases





## 1.7.4 (2021-06-05)


### chore

* skip validate hosts in some cases


### fix

* allow hidden IP address to be valid for license activation (CU-kk4dd7)





## 1.7.3 (2021-05-25)


### chore

* compatibility with latest antd version
* migarte loose mode to compiler assumptions
* prettify code to new standard
* upgrade dependencies to latest minor version


### fix

* do not rely on install_plugins capability, instead use activate_plugins so GIT-synced WP instances work too (CU-k599a2)
* output validate hint after custom help (object destructuring, CU-kb6jyc)
* validate current host with parse_url to avoid some strange scenarios





## 1.7.2 (2021-05-14)


### fix

* sometimes the modal is not shown due to race condition with mobx.configure isolate global state





## 1.7.1 (2021-05-11)


### fix

* automatically refetch announcments for updates (CU-jn95nz)





# 1.7.0 (2021-05-11)


### feat

* introduce Learn More links to different parts of the UI (CU-gv58rr)
* translate frontend into German (CU-ex0u4a)


### fix

* automatically clear page caches after license activation / deactivation (CU-jd7t87)
* ignore IP hostname + port  while validating a new host (CU-j93gd2)
* ignore IP hostnames while validating a new host (CU-j93gd2)
* show notice about email checkbox in feedback formular when note has more than 4 words (CU-gd0zw3)
* usage with deferred scripts and content blocker (DOM waterfall, CU-gn4ng5)
* wrong announcment state directly after first license activation


### refactor

* create wp-webpack package for WordPress packages and plugins
* introduce eslint-config package
* introduce new grunt workspaces package for monolithic usage
* introduce new package to validate composer licenses and generate disclaimer
* introduce new package to validate yarn licenses and generate disclaimer
* introduce new script to run-yarn-children commands
* move build scripts to proper backend and WP package
* move jest scripts to proper backend and WP package
* move PHP Unit bootstrap file to @devowl-wp/utils package
* move PHPUnit and Cypress scripts to @devowl-wp/utils package
* move WP build process to @devowl-wp/utils
* move WP i18n scripts to @devowl-wp/utils
* move WP specific typescript config to @devowl-wp/wp-webpack package
* remove @devowl-wp/development package





## 1.6.3 (2021-04-27)


### fix

* compatibility with WP_SITEURL PHP constant (CU-hd6ntd)
* do not validate new host names in WP CLI and WP Cronjob
* do not validate new hosts for free licenses





## 1.6.2 (2021-04-15)


### chore

* show old and new hostname after license deactivation


### fix

* compatibility with WPML and PolyLang when using different domains (CU-h79b76)





## 1.6.1 (2021-03-30)


### chore

* update text to explain the installation type (CU-g57mdw)


### fix

* group licenses by hostname of each blog instead of blog (CU-g751j8)


### refactor

* use composer autoload to setup constants and package localization





# 1.6.0 (2021-03-23)


### chore

* max. activations per license explain in more detail when limit reached and link to customer center (CU-fn1k7v)


### feat

* allow to migrate from older license keys (CU-fq1kd8)


### fix

* allow to only get the href for the plugin activation link and make API public (CU-fq1kd8)
* consider allow autoupdates as true if previously no auto updates exist (CU-fq1kd8)
* do not deactivate license when saving new URL through General > Settings (CU-g150eg)
* in a multisite installation only consider blogs with Real Cookie Banner active (CU-fyzukg)
* plugin could not be installed if an older version of PuC is used by another plugin
* prefill code from warning / error hint and allow 32 char (non-UUID) format codes (CU-fq1kd8)
* switch to blog while validating new hostname for license (CU-fyzukg)





## 1.5.5 (2021-03-10)


### chore

* hide some notices on try.devowl.io (CU-f53trz)
* update texts (CU-f134wh)


### fix

* automatically deactivate license when migrating / cloning the website and show notice (CU-f134wh)





## 1.5.4 (2021-03-02)


### chore

* highlight "Skip & Deactivate" button in feedback form when deactivating plugin (CU-ewzae8)


### fix

* filter duplicates in deactivation feedback and show error message (CU-ewzae8)
* filter spam deactivation feedback by length, word count and email address MX record (CU-ewzae8)
* use site url instead of home url for activating a license (CU-f134wh)
* use whitespace and refactor coding (CU-ewzae8)





## 1.5.3 (2021-02-24)


### chore

* drop moment bundle where not needed (CU-e94pnh)





## 1.5.2 (2021-02-16)


### fix

* warning (PHP) when previously no autoupdates exist





## 1.5.1 (2021-02-02)


### chore

* hotfix remove function which does not exist in < WordPress 5.5





# 1.5.0 (2021-02-02)


### feat

* introduce new checkbox to enable automatic minor and patch updates (CU-dcyf6c)





## 1.4.5 (2021-01-24)


### fix

* avoid duplicate feedback modals if other plugins of us are active (e.g. RML, CU-cx0ynw)





## 1.4.4 (2021-01-11)


### build

* reduce javascript bundle size by using babel runtime correctly with webpack / babel-loader





## 1.4.3 (2020-12-09)


### chore

* update to webpack v5 (CU-4akvz6)
* updates typings and min. Node.js and Yarn version (CU-9rq9c7)


### fix

* add hint for installation type for better explanation (CU-b8t6qf)





## 1.4.2 (2020-12-01)


### chore

* update dependencies (CU-3cj43t)
* update to composer v2 (CU-4akvjg)


### refactor

* enforce explicit-member-accessibility (CU-a6w5bv)





## 1.4.1 (2020-11-26)


### fix

* show link to account page when max license usage reached (CU-aq0g1g)





# 1.4.0 (2020-11-24)


### feat

* add hasInteractedWithFormOnce property of current blog to REST response (CU-agzcrp)


### fix

* license form was not localized to german (CU-agzcrp)
* use no-store caching for WP REST API calls to avoid issues with browsers and CloudFlare (CU-agzcrp)





## 1.3.4 (2020-11-19)


### fix

* deactivation feedback wrong REST route





## 1.3.3 (2020-11-18)


### fix

* deactivation feedback modal





## 1.3.2 (2020-11-17)


### fix

* duplicate error messages (#acypm6)





## 1.3.1 (2020-11-17)


### fix

* correctly show multisite blogname (#acwzpy)





# 1.3.0 (2020-11-03)


### feat

* allow to disable announcements (#9jwehz)
* translation (#8mrn5a)





# 1.2.0 (2020-10-23)


### feat

* route PATCH PaddleIncompleteOrder (#8ywfdu)


### fix

* typing


### refactor

* use "import type" instead of "import"





# 1.1.0 (2020-10-16)


### build

* use node modules cache more aggressively in CI (#4akvz6)


### chore

* introduce Real Product Manager WordPress client package (#8cxk67)
* update PUC (#8cxk67)
* update PUC (#8cxk67)


### feat

* add checklist in config page header (#8cxk67)
* announcements (#8cxk67)
* introduce feedback modal (#8cxk67)


### fix

* enable old auto updater instead of new one for EA (#8cxk67)
* validate response in PUC (#8cxk67)





# 1.1.0 (2020-10-16)


### build

* use node modules cache more aggressively in CI (#4akvz6)


### chore

* introduce Real Product Manager WordPress client package (#8cxk67)
* update PUC (#8cxk67)
* update PUC (#8cxk67)


### feat

* add checklist in config page header (#8cxk67)
* announcements (#8cxk67)
* introduce feedback modal (#8cxk67)


### fix

* enable old auto updater instead of new one for EA (#8cxk67)
* validate response in PUC (#8cxk67)
