import { QuestionCircleFilled } from "@ant-design/icons";
import { Tag } from "antd";

import { __ } from "../utils/i18n.js";

import type { CSSProperties, FC } from "react";

const LearnMoreTag: FC<{ url: string; style?: CSSProperties; label?: string }> = ({
    url,
    style = undefined,
    label = __("Learn more"),
}) => {
    const useStyle: CSSProperties = {
        cursor: "pointer",
        ...style,
    };

    return (
        <Tag style={useStyle} onClick={() => window.open(url, "_blank")}>
            <QuestionCircleFilled /> {label}
        </Tag>
    );
};

export { LearnMoreTag };
