import { Checkbox, Form, Input } from "antd";
import { observer } from "mobx-react";

import { PLUGIN_UPDATE_FORM_LAYOUT_MARGIN_BOTTOM } from "./form.js";
import { __, _i, _x } from "../../../utils/i18n.js";
import { PluginUpdateLicenseTelemetryDataModal } from "../licenseTelemetryDataModal.js";

import type { PluginUpdate } from "../../../models/pluginUpdate.js";
import type { FC } from "react";

const PluginUpdateTermFields: FC<{ pluginUpdate: PluginUpdate }> = observer(({ pluginUpdate }) => {
    const PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM = {
        ...PLUGIN_UPDATE_FORM_LAYOUT_MARGIN_BOTTOM,
        zoom: 0.8,
    };

    const {
        privacyProvider,
        privacyPolicy,
        allowsTelemetry,
        allowsAutoUpdates,
        allowsNewsletter,
        additionalCheckboxes,
        licenses: [firstLicense],
    } = pluginUpdate;

    return (
        <>
            {allowsAutoUpdates && (
                <Form.Item name="autoUpdates" valuePropName="checked" style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}>
                    <Checkbox>
                        {_i(
                            __(
                                "Updates containing bug fixes and new features will be downloaded and installed automatically.",
                            ),
                            {
                                a: <a href={privacyPolicy} target="_blank" rel="noreferrer" />,
                            },
                        )}
                    </Checkbox>
                </Form.Item>
            )}
            <Form.Item
                name="terms"
                valuePropName="checked"
                required
                rules={[
                    {
                        type: "boolean",
                        required: true,
                        transform: (value) => value || undefined,
                        message: __(
                            "Please confirm the transfer of technical data as this is required for license activation and update functionality.",
                        ),
                    },
                ]}
                style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}
            >
                <Checkbox>
                    {_x(
                        "I allow to transfer technical data about this WordPress installation to the update server of %1$s and get latest announcements. This data is required for license activation and update functionality.",
                        "legal-text",
                        privacyProvider,
                    )}
                </Checkbox>
            </Form.Item>
            {allowsTelemetry && (
                <Form.Item name="telemetry" valuePropName="checked" style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}>
                    <Checkbox>
                        {_i(
                            _x(
                                "I allow telemetry data about the use of this WordPress plugin to be collected in accordance with the %1$s {{a}}privacy policy{{/a}}. This data does not include any personal information about users of the plugin. Collected data ({{aDataExample}}open example of transmitted data{{/aDataExample}}) will be used to provide you with the best possible support and to improve the plugin.",
                                "legal-text",
                                privacyProvider,
                            ),
                            {
                                a: <a href={privacyPolicy} target="_blank" rel="noreferrer" />,
                                aDataExample: (
                                    <PluginUpdateLicenseTelemetryDataModal license={firstLicense} linkWrapper />
                                ),
                            },
                        )}
                    </Checkbox>
                </Form.Item>
            )}
            {additionalCheckboxes.map(({ id, text }) => (
                <Form.Item name={id} key={id} valuePropName="checked" style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}>
                    <Checkbox>{text}</Checkbox>
                </Form.Item>
            ))}
            {allowsNewsletter && (
                <Form.Item name="newsletter" valuePropName="checked" style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}>
                    <Checkbox>
                        {_x(
                            "I would like to receive the %1$s newsletter with WordPress news, sales and product offers (approx. 1-2 per month) via email. I know that I can withdraw my consent for the newsletter at any time.",
                            "legal-text",
                            privacyProvider,
                        )}
                    </Checkbox>
                </Form.Item>
            )}
            <Form.Item
                noStyle
                shouldUpdate={(prevValues, nextValues) => prevValues.newsletter !== nextValues.newsletter}
            >
                {({ getFieldValue }) =>
                    getFieldValue("newsletter") && (
                        <>
                            <Form.Item
                                label={__("First name")}
                                name="firstName"
                                style={PLUGIN_UPDATE_FORM_LAYOUT_MARGIN_BOTTOM}
                                required
                                rules={[{ required: true, message: __("Please enter your first name!") }]}
                            >
                                <Input />
                            </Form.Item>
                            <Form.Item
                                label={__("Email")}
                                name="email"
                                style={PLUGIN_UPDATE_FORM_LAYOUT_MARGIN_BOTTOM}
                                required
                                rules={[
                                    {
                                        type: "email",
                                        required: true,
                                        message: __("Please enter your email address!"),
                                    },
                                ]}
                            >
                                <Input />
                            </Form.Item>
                            <div className="notice notice-info inline below-h2 notice-alt" style={{ margin: 0 }}>
                                <p>
                                    {__(
                                        "Please note that we will send you a confirmation e-mail. Only when you have clicked on the activation link in the email will you receive the newsletter.",
                                    )}
                                </p>
                            </div>
                        </>
                    )
                }
            </Form.Item>
            <Form.Item style={PLUGIN_UPDATE_FORM_LAYOUT_TERM_ITEM}>
                {_i(
                    __(
                        "Information on the processing of your personal data can be found in our {{a}}privacy policy{{/a}}.",
                    ),
                    {
                        a: <a href={privacyPolicy} target="_blank" rel="noreferrer" />,
                    },
                )}
            </Form.Item>
        </>
    );
});

export { PluginUpdateTermFields };
