import { Checkbox, List } from "antd";
import { observer } from "mobx-react";

import { PluginUpdateLicenseListItem } from "./licenseListItem.js";
import { __ } from "../../utils/i18n.js";

import type { PluginUpdate } from "../../models/pluginUpdate.js";
import type { ComponentProps, FC } from "react";

const PluginUpdateLicenseList: FC<{
    onDeactivate?: ComponentProps<typeof PluginUpdateLicenseListItem>["onDeactivate"];
    pluginUpdate: PluginUpdate;
}> = observer(({ onDeactivate, pluginUpdate }) => {
    const { licensedEntries } = pluginUpdate;

    return (
        <>
            <List<(typeof licensedEntries)[0]>
                itemLayout="vertical"
                size="small"
                dataSource={licensedEntries}
                renderItem={(license) => <PluginUpdateLicenseListItem license={license} onDeactivate={onDeactivate} />}
            />
            <p style={{ textAlign: "right" }}>
                <Checkbox
                    disabled={pluginUpdate.busy}
                    checked={pluginUpdate.announcementsActive}
                    onChange={(e) => pluginUpdate.setAnnouncementActive(e.target.checked)}
                >
                    {__("Show announcements for this plugin")}
                </Checkbox>
            </p>
        </>
    );
});

export { PluginUpdateLicenseList };
