/**
 * The entry point for the admin side wp-admin resource.
 */
import "@devowl-wp/utils/antd.scss";
import { Avatar, Card, Form, Space } from "antd";
import { createRoot } from "react-dom/client";

import { ready } from "@devowl-wp/react-utils";

import { PluginUpdateModal } from "./components/pluginUpdate/modal.js";
import { Provider } from "./components/provider.js";
import { listenHashPluginUpdate } from "./others/listenHashPluginUpdate.js";
import { listenPluginDeactivation } from "./others/listenPluginDeactivation.js";
import { listenPluginUpdateLinkClick } from "./others/listenPluginUpdateLinkClick.js";

listenPluginDeactivation();

ready(() => {
    // Create main component for all available features (e.g. license modal)
    const node = document.createElement("div");
    document.body.appendChild(node);
    createRoot(node).render(
        <Provider>
            <PluginUpdateModal />
        </Provider>,
    );

    listenPluginUpdateLinkClick();
    listenHashPluginUpdate();
});

export * from "./others/index.js";
export * from "./components/index.js";
export * from "./wp-api/index.js";
export * from "./store/index.js";

// Provide some UI elements so other plugins can use the same antd class prefix e.g. extending the update modal form
// Currently only used for Real Media Library as it does not yet use an own class prefix
export { Avatar, Card, Form, Space };
