import { RootStore } from "../store/stores.js";

const CLICK_HANDLER_PLUGIN_UPDATE_MODAL_ATTRIBUTE = "data-rpm-wp-client-plugin-update";

/**
 * Listen to clicks on `<a data-rpm-wp-client-license=""` links and open the license modal.
 */
function listenPluginUpdateLinkClick() {
    document.addEventListener("click", (e) => {
        const plugin = (e.target as HTMLAnchorElement)?.getAttribute(CLICK_HANDLER_PLUGIN_UPDATE_MODAL_ATTRIBUTE);
        if (plugin) {
            RootStore.get.pluginUpdateStore.showInModal(plugin);
            e.preventDefault();
        }
    });
}

export { listenPluginUpdateLinkClick, CLICK_HANDLER_PLUGIN_UPDATE_MODAL_ATTRIBUTE };
