import { observable, runInAction } from "mobx";

import { BaseOptions } from "@devowl-wp/utils";

import type { RootStore } from "./stores.js";

class OptionStore extends BaseOptions {
    @observable
    public others: {
        currentUserFullName: string;
        names: Record<
            string,
            {
                name: string;
                plugin: string;
                privacyPolicy: string;
                privacyProvider: string;
                isPluginActiveForNetwork: boolean;
                hasAtLeastOneActiveLicense: boolean;
            }
        >;
    };

    public readonly pureSlug: ReturnType<typeof BaseOptions.getPureSlug>;

    public readonly pureSlugCamelCased: ReturnType<typeof BaseOptions.getPureSlug>;

    public readonly rootStore: RootStore;

    public constructor(rootStore: RootStore) {
        super();
        this.rootStore = rootStore;
        this.pureSlug = BaseOptions.getPureSlug(process.env.slug);
        this.pureSlugCamelCased = BaseOptions.getPureSlug(process.env.slug, true);

        // Use the localized WP object to fill this object values.
        runInAction(() => Object.assign(this, (window as any)[this.pureSlugCamelCased]));
    }
}

export { OptionStore };
