import { createLocalizationFactory } from "@devowl-wp/utils";

// Only needed once per `window`
let FACTORY_MEMO: ReturnType<typeof createLocalizationFactory>;

function get() {
    return FACTORY_MEMO
        ? FACTORY_MEMO
        : (FACTORY_MEMO = createLocalizationFactory(`${process.env.rootSlug}-${process.env.slug}`));
}

const _n: (typeof FACTORY_MEMO)["_n"] = (...args) => get()._n(...args);
const _nx: (typeof FACTORY_MEMO)["_nx"] = (...args) => get()._nx(...args);
const _x: (typeof FACTORY_MEMO)["_x"] = (...args) => get()._x(...args);
const __: (typeof FACTORY_MEMO)["__"] = (...args) => get().__(...args);
const _i: (typeof FACTORY_MEMO)["_i"] = (...args) => get()._i(...args);

export { _n, _nx, _x, __, _i };
