import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestAnnouncementActive: RouteLocationInterface = {
    path: "/announcement/:slug/active",
    method: RouteHttpVerb.POST,
};

interface RequestRouteAnnouncementActive extends RouteRequestInterface {
    state: boolean;
}

interface ParamsRouteAnnouncementActive extends RouteParamsInterface {
    slug: string;
}

interface ResponseRouteAnnouncementActive extends RouteResponseInterface {
    success: boolean;
}

export {
    locationRestAnnouncementActive,
    type RequestRouteAnnouncementActive,
    type ParamsRouteAnnouncementActive,
    type ResponseRouteAnnouncementActive,
};
