import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestPluginFeedbackPost: RouteLocationInterface = {
    path: "/feedback/:slug",
    method: RouteHttpVerb.POST,
};

interface RequestRoutePluginFeedbackPost extends RouteRequestInterface {
    skip?: boolean;
    reason: string;
    note: string;
    email?: string;
    name?: string;
    deactivateLicense?: boolean;
}

interface ParamsRoutePluginFeedbackPost extends RouteParamsInterface {
    slug: string;
}

interface ResponseRoutePluginFeedbackPost extends RouteResponseInterface {
    sentFeedback: boolean;
    deactivatedLicense: Record<number, boolean>;
}

export {
    locationRestPluginFeedbackPost,
    type RequestRoutePluginFeedbackPost,
    type ParamsRoutePluginFeedbackPost,
    type ResponseRoutePluginFeedbackPost,
};
