import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRoutePluginUpdateGet } from "./pluginUpdate.get.js";

const locationRestLicenseDelete: RouteLocationInterface = {
    path: "/plugin-update/:slug/license/:blogId",
    method: RouteHttpVerb.DELETE,
};

interface RequestRouteLicenseDelete extends RouteRequestInterface {}

interface ParamsRouteLicenseDelete extends RouteParamsInterface {
    slug: string;
    blogId: number;
}

interface ResponseRouteLicenseDelete extends ResponseRoutePluginUpdateGet {}

export {
    locationRestLicenseDelete,
    type RequestRouteLicenseDelete,
    type ParamsRouteLicenseDelete,
    type ResponseRouteLicenseDelete,
};
