import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRoutePluginUpdateGet } from "./pluginUpdate.get.js";

const locationRestLicenseRetry: RouteLocationInterface = {
    path: "/plugin-update/:slug/license/:blogId/retry",
    method: RouteHttpVerb.POST,
};

interface RequestRouteLicenseRetry extends RouteRequestInterface {}

interface ParamsRouteLicenseRetry extends RouteParamsInterface {
    slug: string;
    blogId: number;
}

interface ResponseRouteLicenseRetry extends ResponseRoutePluginUpdateGet {}

export {
    locationRestLicenseRetry,
    type RequestRouteLicenseRetry,
    type ParamsRouteLicenseRetry,
    type ResponseRouteLicenseRetry,
};
