import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

const locationRestLicenseTelemetryGet: RouteLocationInterface = {
    path: "/plugin-update/:slug/telemetry/:blogId",
    method: RouteHttpVerb.GET,
};

interface RequestRouteLicenseTelemetryGet extends RouteRequestInterface {}

interface ParamsRouteLicenseTelemetryGet extends RouteParamsInterface {
    slug: string;
    blogId: number;
}

interface ResponseRouteLicenseTelemetryGet extends RouteResponseInterface {
    slug: string;
}

export {
    locationRestLicenseTelemetryGet,
    type RequestRouteLicenseTelemetryGet,
    type ParamsRouteLicenseTelemetryGet,
    type ResponseRouteLicenseTelemetryGet,
};
