import type {
    RouteLocationInterface,
    RouteParamsInterface,
    RouteRequestInterface,
    RouteResponseInterface,
} from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ValidateHint } from "../types/validateHint.js";

const locationRestPluginUpdateGet: RouteLocationInterface = {
    path: "/plugin-update/:slug",
    method: RouteHttpVerb.GET,
};

interface RequestRoutePluginUpdateGet extends RouteRequestInterface {}

interface ParamsRoutePluginUpdateGet extends RouteParamsInterface {
    slug: string;
}

interface ResponseRoutePluginUpdateGetLicenseEntity {
    uuid: string;
    blog: number;
    host: string;
    blogName: string;
    programmatically:
        | false
        | {
              code: string;
              type: "development" | "production";
              telemetry: boolean;
          };
    installationType: "development" | "production" | false;
    telemetryDataSharingOptIn: boolean;
    code: string | false;
    hint?: ValidateHint | false;
    /**
     * Not fully typed, only what needed, see `backends/real-product-manager/src/types/route/license/activation/license-activation.get.ts`.
     */
    remote?: {
        licenseActivation: {
            activatedAt: Date;
            telemetryDataSharingOptIn: boolean;
        };
    };
    noUsage: boolean;
}

interface ResponseRoutePluginUpdateGet extends RouteResponseInterface {
    slug: string;
    licenses: Array<ResponseRoutePluginUpdateGetLicenseEntity>;
    hasInteractedWithFormOnce: boolean;
    name: string;
    needsLicenseKeys: boolean;
    privacyProvider: string;
    privacyPolicy: string;
    accountSiteUrl: string;
    additionalCheckboxes: Array<{ id: string; text: string }>;
    licenseKeyHelpUrl: string;
    announcementsActive: boolean;
    allowsAutoUpdates: boolean;
    allowsTelemetry: boolean;
    allowsNewsletter: boolean;
    potentialNewsletterUser: {
        firstName: string;
        email: string;
    };
    checkUpdateLink: string | false;
    showBlogName: boolean;
    showNetworkWideUpdateIssueNotice: boolean;
}

export {
    locationRestPluginUpdateGet,
    type RequestRoutePluginUpdateGet,
    type ParamsRoutePluginUpdateGet,
    type ResponseRoutePluginUpdateGet,
    type ResponseRoutePluginUpdateGetLicenseEntity,
};
