import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRoutePluginUpdateGet } from "./pluginUpdate.get.js";
import type { ValidateHint } from "../types/validateHint.js";

const locationRestPluginUpdatePatch: RouteLocationInterface = {
    path: "/plugin-update/:slug",
    method: RouteHttpVerb.PATCH,
};

interface RequestRoutePluginUpdatePatch extends RouteRequestInterface {
    licenses: string; // WP REST API 5.2 does not yet support JSON schema
    terms: boolean;
    telemetry?: boolean;
    newsletter?: boolean;
    firstName?: string;
    email?: string;
}

interface ParamsRoutePluginUpdatePatch extends RouteParamsInterface {
    slug: string;
}

interface ResponseRoutePluginUpdatePatch extends ResponseRoutePluginUpdateGet {}

type ResponseRoutePluginUpdatePatchErrorInvalidKeysData = Record<
    number,
    ValidateHint & {
        debug: {
            error_data: any;
            errors: Record<number, string>;
        };
    }
>;

export {
    locationRestPluginUpdatePatch,
    type RequestRoutePluginUpdatePatch,
    type ParamsRoutePluginUpdatePatch,
    type ResponseRoutePluginUpdatePatch,
    type ResponseRoutePluginUpdatePatchErrorInvalidKeysData,
};
