import type { RouteLocationInterface, RouteParamsInterface, RouteRequestInterface } from "@devowl-wp/utils";
import { RouteHttpVerb } from "@devowl-wp/utils";

import type { ResponseRoutePluginUpdateGet } from "./pluginUpdate.get.js";

const locationRestPluginUpdateSkipPost: RouteLocationInterface = {
    path: "/plugin-update/:slug/skip",
    method: RouteHttpVerb.POST,
};

interface RequestRoutePluginUpdateSkipPost extends RouteRequestInterface {}

interface ParamsRoutePluginUpdateSkipPost extends RouteParamsInterface {
    slug: string;
}

interface ResponseRoutePluginUpdateSkipPost extends ResponseRoutePluginUpdateGet {
    success: boolean;
}

export {
    locationRestPluginUpdateSkipPost,
    type RequestRoutePluginUpdateSkipPost,
    type ParamsRoutePluginUpdateSkipPost,
    type ResponseRoutePluginUpdateSkipPost,
};
