import { List } from "antd";

import { ErrorModalListItem } from "./listItem.js";

import type { useStatusErrors } from "../../hooks/useStatusErrors.js";
import type { FC } from "react";

type ErrorItems = ReturnType<typeof useStatusErrors>["errors"];

const ErrorModalList: FC<{ list: ErrorItems }> = ({ list }) => {
    return (
        <List<ErrorItems[""]>
            size="small"
            dataSource={Object.values(list)}
            renderItem={(item) => <ErrorModalListItem item={item} key={item.type} />}
        />
    );
};

export { ErrorModalList };
