import { IconProvider } from "@ant-design/icons";
import { App, ConfigProvider } from "antd";

import type { FC, PropsWithChildren } from "react";

const Provider: FC<PropsWithChildren> = ({ children }) => (
    <ConfigProvider
        prefixCls={process.env.ANTD_PREFIX}
        iconPrefixCls={`${process.env.ANTD_PREFIX}-anticon`}
        theme={{
            token: {
                colorPrimary: "#2271b1",
                borderRadius: 3,
            },
        }}
    >
        <IconProvider value={{ prefixCls: `${process.env.ANTD_PREFIX}-anticon` }}>
            <App>{children}</App>
        </IconProvider>
    </ConfigProvider>
);

export { Provider };
