import create from "activity-detector";

const WINDOW_ACTIVITY_DETECTOR_IS_ACTIVE_KEY = "realQueueIsIdle";

declare global {
    interface Window {
        /**
         * Is the queue currently idle?
         */
        realQueueIsIdle?: boolean;
    }
}

/**
 * Detect idle time. You can get the state from `window.realQueueIsIdle [boolean]`.
 */
function createActivityDetector() {
    const activityDetector = create({
        autoInit: false,
    });

    activityDetector.on("idle", () => {
        window[WINDOW_ACTIVITY_DETECTOR_IS_ACTIVE_KEY] = true;
    });

    activityDetector.on("active", () => {
        window[WINDOW_ACTIVITY_DETECTOR_IS_ACTIVE_KEY] = false;
    });

    // I want to start the activity detector now!
    activityDetector.init();
}

export { createActivityDetector, WINDOW_ACTIVITY_DETECTOR_IS_ACTIVE_KEY };
