import PQueue from "p-queue";

import { RealQueueClass } from "./queueClass.js";

import type { DefaultAddOptions } from "./queueClass.js";

declare global {
    interface Window {
        realQueueInstance?: RealQueueClass;
        realQueueInstancePQueue?: PQueue<RealQueueClass, DefaultAddOptions>;
    }
}

/**
 * Create a page-wide queue saved in `window`.
 */
function getGlobalQueue() {
    if (!window.realQueueInstancePQueue) {
        window.realQueueInstancePQueue = new PQueue<RealQueueClass, DefaultAddOptions>({
            autoStart: true,
            concurrency: 1,
            queueClass: RealQueueClass,
        });
    }

    return window.realQueueInstance;
}

export { getGlobalQueue };
