import { request } from "../../utils/request.js";
import { locationRestJobGet } from "../../wp-api/job.get.js";

import type { ParamsRouteJobGet, RequestRouteJobGet, ResponseRouteJobGet } from "../../wp-api/job.get.js";

/**
 * Fetch job by id. Additionally, you can set a `lock` boolean so other tabs could
 * not process this job furthermore. This is useful for client jobs.
 */
async function fetchJob(id: number, lock?: boolean) {
    return await request<RequestRouteJobGet, ParamsRouteJobGet, ResponseRouteJobGet>({
        location: locationRestJobGet,
        params: {
            id,
            lock,
        },
    });
}

export { fetchJob };
