import { JOBS_RETRIED_EVENT } from "../../types/events/jobsRetried.js";
import { request as utilsRequest } from "../../utils/request.js";
import { locationRestJobsSkipPost } from "../../wp-api/jobsSkip.post.js";
import { fetchStatus } from "../fetchStatus.js";

import type { JobsRetriedEvent } from "../../types/events/jobsRetried.js";
import type {
    ParamsRouteJobsSkipPost,
    RequestRouteJobsSkipPost,
    ResponseRouteJobsSkipPost,
} from "../../wp-api/jobsSkip.post.js";

/**
 * Skip jobs by e.g. type.
 */
async function skipJobs(request: RequestRouteJobsSkipPost) {
    const response = await utilsRequest<RequestRouteJobsSkipPost, ParamsRouteJobsSkipPost, ResponseRouteJobsSkipPost>({
        location: locationRestJobsSkipPost,
        request,
    });

    document.dispatchEvent(
        new CustomEvent<JobsRetriedEvent>(JOBS_RETRIED_EVENT, {
            detail: {
                request,
                response,
            },
        }),
    );

    await fetchStatus(true);
}

export { skipJobs };
