import { LOCAL_STORAGE_KEY_QUEUE_NOTIFY_WORKER_PREFIX } from "./notifyWorkerTab.js";
import { localStorageTest } from "../../utils/localStorageTest.js";
import { getStaticOptions } from "../../utils/options.js";

/**
 * Clear all worker notifications.
 */
function clearWorkerNotifications() {
    if (localStorageTest()) {
        const lsPrefix = `${LOCAL_STORAGE_KEY_QUEUE_NOTIFY_WORKER_PREFIX}${getStaticOptions().localStorageSuffix}`;
        for (const lsEntryName of Object.keys(localStorage)) {
            if (lsEntryName.startsWith(lsPrefix)) {
                localStorage.removeItem(lsEntryName);
            }
        }

        return true;
    }
    return false;
}

export { clearWorkerNotifications };
