import { localStorageTest } from "../../utils/localStorageTest.js";
import { getStaticOptions } from "../../utils/options.js";

const LOCAL_STORAGE_KEY_QUEUE_NOTIFY_WORKER_PREFIX = "real-queue-notify-worker-";

type WorkerTabNotification<Data = any> = {
    event: string;
    data?: Data;
};

/**
 * Notify worker tab to do something.
 */
function notifyWorkerTab(data: WorkerTabNotification) {
    if (localStorageTest()) {
        const lsKey = `${LOCAL_STORAGE_KEY_QUEUE_NOTIFY_WORKER_PREFIX}${
            getStaticOptions().localStorageSuffix
        }-${new Date().getTime()}`;

        localStorage.setItem(lsKey, JSON.stringify(data));
        return true;
    }

    return false;
}

export { notifyWorkerTab, LOCAL_STORAGE_KEY_QUEUE_NOTIFY_WORKER_PREFIX, type WorkerTabNotification };
