import type { fetchJob } from "../../queue/job/fetchJob.js";
import type { saveJobResult } from "../../queue/job/saveJobResult.js";
import type { Job } from "../job.js";

/**
 * You need to append the `type` to the event name, e.g. `RealQueue/ClientJob/example`.
 *
 * This should execute the client job via JavaScript. Keep in mind, that you need to manually
 * update the process via a server request for each item! See also the PHP class
 * `DevOwl\RealQueue\queue\Job#worker` for more information.
 *
 * You are allowed to throw errors, this causes the client job to be retried according to `retries`.
 */
export const CLIENT_JOB_EVENT_PREFIX = "RealQueue/ClientJob/";

export type ClientJobEvent<JobData = any> = {
    job: Job<JobData>;
    resolve: (value: void | PromiseLike<void>) => void;
    reject: (reason?: Parameters<typeof saveJobResult>[2]) => void;
    /**
     * The number of runs retried for this job, e.g. your code has thrown an exception
     */
    run: number;
    fetchJob: typeof fetchJob;
    saveJobResult: typeof saveJobResult;
};
