interface Job<JobData = any> {
    id: number;
    callable: any;
    created: string;
    data: JobData;
    delay_ms: number;
    duration_ms: number;
    group_uuid?: string;
    group_position?: number;
    group_total?: number;
    lock_until: number;
    locked: boolean;
    process: number;
    process_total: number;
    runs: number;
    retries: number;
    type: string;
    worker: "server" | "client";
    exception?: {
        error_data: {
            [key: string]: any;
        };
        errors: {
            [key: string]: string[];
        };
    };
}

export { type Job };
