let memoizeSupported: boolean = undefined;

/**
 * Checks if localStorage is available. E.g. private modes in browsers
 * does not allow to write to localStorage.
 */
function localStorageTest() {
    if (typeof memoizeSupported === "boolean") {
        return memoizeSupported;
    }

    const test = "real-queue-test";
    try {
        localStorage.setItem(test, test);
        localStorage.removeItem(test);
        memoizeSupported = true;
        return true;
    } catch (e) {
        memoizeSupported = false;
        return false;
    }
}

export { localStorageTest };
