import { BaseOptions } from "@devowl-wp/utils";

import type { ResponseRouteStatusGet } from "../wp-api/status.get.js";

/**
 * As we do not rely on a real store in our package (should be lightweight)
 * we can use the window object as variable.
 */
type OptionsOthers = {
    localStorageSuffix: string;
    remaining: ResponseRouteStatusGet["remaining"];
    errors: ResponseRouteStatusGet["errors"];
};

const getStaticOptions = () => (window as any)[BaseOptions.getPureSlug(process.env.slug, true)].others as OptionsOthers;

export { type OptionsOthers, getStaticOptions };
